package com.ruoyi.system.domain.business;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 发票审批记录对象 base_invoice_audit_record
 *
 * @author gm
 * @date 2025-02-25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseInvoiceAuditRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 发票id */
    @Excel(name = "发票id")
    private Long invoiceId;

    /** 审核状态  1 通过 2 拒绝 3 冲红 */
    @Excel(name = "审核状态  1 通过 2 拒绝 3 冲红")
    private Integer shzt;

    /** 审批人 */
    @Excel(name = "审批人")
    private String spr;

    /** 审批时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "审批时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date spTime;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;
}
