package com.ruoyi.system.domain.business;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同审核记录对象 base_contract_audit_record
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseContractAuditRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 节点 */
    @Excel(name = "节点")
    private Integer jd;

    /** 操作 */
    @Excel(name = "操作")
    private Integer cz;

    /** 处理意见 */
    @Excel(name = "处理意见")
    private String clyj;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jd", getJd())
            .append("cz", getCz())
            .append("clyj", getClyj())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .toString();
    }
}
