package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BasePerformanceCompleteInfo;
import com.ruoyi.system.domain.business.vo.PerformanceCompleteVo;
import com.ruoyi.system.domain.business.vo.PerformanceReportVo;
import com.ruoyi.system.service.business.IBasePerformanceCompleteInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;

/**
 * 业绩目标Controller
 *
 * @author gm
 * @date 2025-06-06
 */
@RestController
@RequestMapping("/performance/complete")
public class BasePerformanceCompleteInfoController extends BaseController
{
    @Autowired
    private IBasePerformanceCompleteInfoService basePerformanceCompleteInfoService;

    /**
     * 查询业绩目标列表
     */
   //  @PreAuthorize("@ss.hasPermi('system:performance:list')")
    @GetMapping("/list")
    public AjaxResult list(BasePerformanceCompleteInfo basePerformanceCompleteInfo)
    {
//        startPage();
        List<PerformanceCompleteVo> list = basePerformanceCompleteInfoService.selectBasePerformanceCompleteInfoList(basePerformanceCompleteInfo);
        return success(list);
    }

    /**
     * 导出业绩目标列表
     */
  //  @PreAuthorize("@ss.hasPermi('system:performance:export')")
    @Log(title = "业绩目标", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BasePerformanceCompleteInfo basePerformanceCompleteInfo)
    {
        List<BasePerformanceCompleteInfo> list = basePerformanceCompleteInfoService.selectBasePerformanceCompleteInfos(basePerformanceCompleteInfo);
        ExcelUtil<BasePerformanceCompleteInfo> util = new ExcelUtil<BasePerformanceCompleteInfo>(BasePerformanceCompleteInfo.class);
        util.exportExcel(response, list, "业绩目标数据");
    }

    /**
     * 获取业绩目标详细信息
     */
   // @PreAuthorize("@ss.hasPermi('system:performance:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(basePerformanceCompleteInfoService.selectBasePerformanceCompleteInfoById(id));
    }

    /**
     * 新增业绩目标
     */
    //@PreAuthorize("@ss.hasPermi('system:performance:add')")
    @Log(title = "业绩目标", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BasePerformanceCompleteInfo basePerformanceCompleteInfo)
    {
        return toAjax(basePerformanceCompleteInfoService.insertBasePerformanceCompleteInfo(basePerformanceCompleteInfo));
    }

    /**
     * 修改业绩目标
     */
   // @PreAuthorize("@ss.hasPermi('system:performance:edit')")
    @Log(title = "业绩目标", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PerformanceCompleteVo performanceCompleteVo)
    {
        basePerformanceCompleteInfoService.updateBasePerformanceCompleteInfo(performanceCompleteVo);
        return success();
    }

    /**
     * 删除业绩目标
     */
    //@PreAuthorize("@ss.hasPermi('system:performance:remove')")
    @Log(title = "业绩目标", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(basePerformanceCompleteInfoService.deleteBasePerformanceCompleteInfoByIds(ids));
    }

        @GetMapping(value = "/report")
    public AjaxResult performanceReport(Integer periodType)
    {
        List<PerformanceReportVo> performanceReportVos = basePerformanceCompleteInfoService.performanceReport(periodType);
        return success(performanceReportVos);
    }
}
