package com.ruoyi.system.service.business.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.MoneyConverter;
import com.ruoyi.system.domain.business.BaseContractAuditRecord;
import com.ruoyi.system.domain.business.BaseContractInfo;
import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;
import com.ruoyi.system.domain.business.vo.ContractCollectVo;
import com.ruoyi.system.mapper.SysRoleMapper;
import com.ruoyi.system.mapper.business.BaseContractAuditRecordMapper;
import com.ruoyi.system.mapper.business.BaseContractInfoMapper;
import com.ruoyi.system.mapper.business.BaseContractPeriodsInfoMapper;
import com.ruoyi.system.mapper.business.BaseInvoiceInfoMapper;
import com.ruoyi.system.service.business.IBaseContractInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 合同信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseContractInfoServiceImpl implements IBaseContractInfoService {
    @Autowired
    private BaseContractInfoMapper baseContractInfoMapper;

    @Autowired
    private BaseContractPeriodsInfoMapper baseContractPeriodsInfoMapper;

    @Autowired
    private BaseContractAuditRecordMapper baseContractAuditRecordMapper;

    @Autowired
    private SysRoleMapper sysRoleMapper;

    @Autowired
    private BaseInvoiceInfoMapper baseInvoiceInfoMapper;

    /**
     * 查询合同信息
     *
     * @param id 合同信息主键
     * @return 合同信息
     */
    @Override
    public BaseContractInfo selectBaseContractInfoById(Long id) {
        BaseContractInfo baseContractInfo = baseContractInfoMapper.selectBaseContractInfoById(id);

        if (ObjectUtil.isNotEmpty(baseContractInfo)) {
            List<BaseContractPeriodsInfo> baseContractPeriodsInfos = baseContractPeriodsInfoMapper.selectBaseContractPeriodsInfoByContractId(baseContractInfo.getId());
            baseContractInfo.setBaseContractPeriodsInfos(baseContractPeriodsInfos);

            List<BaseContractAuditRecord> baseContractAuditRecords = baseContractAuditRecordMapper.selectBaseContractAuditRecordByContractId(baseContractInfo.getId());
            baseContractInfo.setBaseContractAuditRecords(baseContractAuditRecords);
        }
        return baseContractInfo;
    }

    /**
     * 查询合同信息列表
     *
     * @param baseContractInfo 合同信息
     * @return 合同信息
     */
    @Override
    public List<BaseContractInfo> selectBaseContractInfoList(BaseContractInfo baseContractInfo) {
        return baseContractInfoMapper.selectBaseContractInfoList(baseContractInfo);
    }

    /**
     * 新增合同信息
     *
     * @param baseContractInfo 合同信息
     * @return 结果
     */
    @Override
    public int insertBaseContractInfo(BaseContractInfo baseContractInfo) {

        int result = baseContractInfoMapper.insertBaseContractInfo(baseContractInfo);
        baseContractInfo.setCreateTime(DateUtils.getNowDate());
        if (ObjectUtil.isNotEmpty(baseContractInfo.getBaseContractPeriodsInfos())) {
            for (BaseContractPeriodsInfo baseContractPeriodsInfo : baseContractInfo.getBaseContractPeriodsInfos()) {
                baseContractPeriodsInfo.setContractId(baseContractInfo.getId());
                baseContractPeriodsInfoMapper.insertBaseContractPeriodsInfo(baseContractPeriodsInfo);
            }
        }
        BaseContractAuditRecord baseContractAuditRecord = new BaseContractAuditRecord();
        baseContractAuditRecord.setContractId(baseContractInfo.getId());
        baseContractAuditRecord.setJd(1);
        baseContractAuditRecord.setCz(1);
        baseContractAuditRecord.setClyj("/");
        baseContractAuditRecord.setCreateTime(new Date());
        baseContractAuditRecord.setCreateBy(baseContractInfo.getCreateBy());
        baseContractAuditRecordMapper.insertBaseContractAuditRecord(baseContractAuditRecord);
        return result;
    }

    /**
     * 修改合同信息
     *
     * @param baseContractInfo 合同信息
     * @param user
     * @return 结果
     */
    @Override
    public int updateBaseContractInfo(BaseContractInfo baseContractInfo, SysUser user) {
        baseContractInfo.setUpdateTime(DateUtils.getNowDate());
        if (baseContractInfo.getShzt() != null) {
            baseContractInfo.setShrId(user.getUserId());
            baseContractInfo.setShrName(user.getNickName());
            BaseContractAuditRecord baseContractAuditRecord = new BaseContractAuditRecord();
            baseContractAuditRecord.setContractId(baseContractInfo.getId());
            baseContractAuditRecord.setJd(2);
            baseContractAuditRecord.setCz(1);
            baseContractAuditRecord.setClyj(baseContractInfo.getBz());
            baseContractAuditRecordMapper.insertBaseContractAuditRecord(baseContractAuditRecord);
        }
        return baseContractInfoMapper.updateBaseContractInfo(baseContractInfo);
    }

    /**
     * 批量删除合同信息
     *
     * @param ids 需要删除的合同信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractInfoByIds(Long[] ids) {
        return baseContractInfoMapper.deleteBaseContractInfoByIds(ids);
    }

    /**
     * 删除合同信息信息
     *
     * @param id 合同信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractInfoById(Long id) {
        return baseContractInfoMapper.deleteBaseContractInfoById(id);
    }

    @Override
    public List<BaseContractInfo> selectBaseContractAuditList(BaseContractInfo baseContractInfo, LoginUser loginUser) {
        List<BaseContractInfo> baseContractInfos = new ArrayList<>();
        if (baseContractInfo.getShrId() != null) {
            baseContractInfos = baseContractInfoMapper.selectBaseContractInfoList(baseContractInfo);
        } else {
            List<Long> longs = sysRoleMapper.selectRoleListByUserId(loginUser.getUserId());
            for (Long aLong : longs) {
                SysRole sysRole = sysRoleMapper.selectRoleById(aLong);
                if (sysRole.getRoleKey().equals("audit")) {
                    baseContractInfos = baseContractInfoMapper.selectBaseContractInfoList(baseContractInfo);
                }
            }
        }
        return baseContractInfos;
    }

    @Override
    public ContractCollectVo getCollect(Long contractId) {
        ContractCollectVo contractCollectVo = baseContractInfoMapper.queryContractAmount(contractId);
        if (contractCollectVo != null && contractCollectVo.getContractAmount() != null && contractCollectVo.getToTheAmount() != null) {
            contractCollectVo.setPayeeAmount(contractCollectVo.getContractAmount().subtract(contractCollectVo.getToTheAmount()));
            BigDecimal invoiceAmount = baseInvoiceInfoMapper.queryInvoiceAmount(contractId);
            if (ObjectUtil.isNotNull(invoiceAmount)) {
                contractCollectVo.setMakeInvoiceAmount(invoiceAmount);
            }
        } else {
            contractCollectVo = new ContractCollectVo();
        }
        return contractCollectVo;
    }

    @Override
    public List<BaseContractPeriodsInfo> getPeriodInfo(BaseContractInfo baseContractInfo) {
        List<BaseContractPeriodsInfo> result = new ArrayList<>();

        String fkbl = baseContractInfo.getFkbl();
        String newStr = fkbl.replaceAll("," , "");
        String[] split = newStr.split("%");
        for (int i = 0; i < split.length; i++) {
            BaseContractPeriodsInfo baseContractPeriod = new BaseContractPeriodsInfo();
            switch (i) {
                case 0:
                    baseContractPeriod.setQs("一期");
                    break;
                case 1:
                    baseContractPeriod.setQs("二期");
                    break;
                case 2:
                    baseContractPeriod.setQs("三期");
                    break;
                case 3:
                    baseContractPeriod.setQs("四期");
                    break;
            }
            BigDecimal amount = baseContractInfo.getHtze().divide(BigDecimal.valueOf(100),RoundingMode.UP).multiply(new BigDecimal(split[i])).setScale(0, RoundingMode.UP);
            baseContractPeriod.setJe(amount);
            baseContractPeriod.setMs(MoneyConverter.convert(amount));
            result.add(baseContractPeriod);
        }
        return result;
    }
}
