package com.ruoyi.system.domain.business;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同审核记录对象 base_contract_audit_record
 *
 * @author gm
 * @date 2025-02-10
 */
public class BaseContractAuditRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 节点 */
    @Excel(name = "节点")
    private Integer jd;

    /** 操作 */
    @Excel(name = "操作")
    private Integer cz;

    /** 处理意见 */
    @Excel(name = "处理意见")
    private String clyj;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setJd(Integer jd)
    {
        this.jd = jd;
    }

    public Integer getJd()
    {
        return jd;
    }
    public void setCz(Integer cz)
    {
        this.cz = cz;
    }

    public Integer getCz()
    {
        return cz;
    }
    public void setClyj(String clyj)
    {
        this.clyj = clyj;
    }

    public String getClyj()
    {
        return clyj;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jd", getJd())
            .append("cz", getCz())
            .append("clyj", getClyj())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .toString();
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
}
