package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BaseCustomFollowRecord;

import java.util.List;

/**
 * 客户跟踪记录Mapper接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface BaseCustomFollowRecordMapper
{
    /**
     * 查询客户跟踪记录
     *
     * @param id 客户跟踪记录主键
     * @return 客户跟踪记录
     */
    public BaseCustomFollowRecord selectBaseCustomFollowRecordById(Long id);

    /**
     * 查询客户跟踪记录列表
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 客户跟踪记录集合
     */
    public List<BaseCustomFollowRecord> selectBaseCustomFollowRecordList(BaseCustomFollowRecord baseCustomFollowRecord);

    /**
     * 新增客户跟踪记录
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 结果
     */
    public int insertBaseCustomFollowRecord(BaseCustomFollowRecord baseCustomFollowRecord);

    /**
     * 修改客户跟踪记录
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 结果
     */
    public int updateBaseCustomFollowRecord(BaseCustomFollowRecord baseCustomFollowRecord);

    /**
     * 删除客户跟踪记录
     *
     * @param id 客户跟踪记录主键
     * @return 结果
     */
    public int deleteBaseCustomFollowRecordById(Long id);

    /**
     * 批量删除客户跟踪记录
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBaseCustomFollowRecordByIds(Long[] ids);
}
