package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BasePaymentCollectionInfo;

import java.util.List;

/**
 * 回款信息Mapper接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface BasePaymentCollectionInfoMapper
{
    /**
     * 查询回款信息
     *
     * @param id 回款信息主键
     * @return 回款信息
     */
    public BasePaymentCollectionInfo selectBasePaymentCollectionInfoById(Long id);

    /**
     * 查询回款信息列表
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 回款信息集合
     */
    public List<BasePaymentCollectionInfo> selectBasePaymentCollectionInfoList(BasePaymentCollectionInfo basePaymentCollectionInfo);

    /**
     * 新增回款信息
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 结果
     */
    public int insertBasePaymentCollectionInfo(BasePaymentCollectionInfo basePaymentCollectionInfo);

    /**
     * 修改回款信息
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 结果
     */
    public int updateBasePaymentCollectionInfo(BasePaymentCollectionInfo basePaymentCollectionInfo);

    /**
     * 删除回款信息
     *
     * @param id 回款信息主键
     * @return 结果
     */
    public int deleteBasePaymentCollectionInfoById(Long id);

    /**
     * 批量删除回款信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBasePaymentCollectionInfoByIds(Long[] ids);
}
