package com.ruoyi.system.domain.business;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 客户跟踪记录对象 base_custom_follow_record
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseCustomFollowRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 客户表id */
    @Excel(name = "客户表id")
    private Long customId;

    /** 跟进内容 */
    @Excel(name = "跟进内容")
    private String gjnr;

    /** 跟进方式 */
    @Excel(name = "跟进方式")
    private Long gjfs;

    /** 跟进人 */
    @Excel(name = "跟进人")
    private String gjr;

    /** 跟进时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "跟进时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date gjTime;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 是否删除 1 删除 0 正常 */
    @Excel(name = "是否删除 1 删除 0 正常")
    private Long deleteFlag;

}
