package com.ruoyi.web.controller.compoment;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.business.BaseCustomInfo;
import com.ruoyi.system.service.business.IBaseCustomInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.Instant;
import java.util.Date;

@RestController("")
@RequestMapping("baidu/clue")
@Slf4j
public class BaiduClueController {

    @Autowired
    private IBaseCustomInfoService iBaseCustomInfoService;

    private static final String TOKEN = "A1B2C3D4E5F6";


    @PostMapping(value = "/msg")
    public AjaxResult msg(@RequestBody JSONObject json) {
        String token = json.getString("token");
        if (token == null || !token.equals(TOKEN)) {
            return AjaxResult.error("token不匹配");
        }
        BaseCustomInfo baseCustomInfo = new BaseCustomInfo();
        JSONArray from = json.getJSONArray("formDetail");
        if (ObjectUtil.isNotEmpty(from)) {
            for (int i = 0; i < from.size(); i++) {
                JSONObject data = from.getJSONObject(i);
                if (data.getString("type").equals("name")) {
                    baseCustomInfo.setKhxm(data.getString("value"));
                }
            }
        }
        String ucName = json.getString("ucName");
        if (ucName.contains("软艺")) {
            baseCustomInfo.setKhly(1);
        }
        if (ucName.contains("软通")) {
            baseCustomInfo.setKhly(2);
        }
        if (ucName.contains("网联")) {
            baseCustomInfo.setKhly(3);
        }
        if (ucName.contains("软盈")) {
            baseCustomInfo.setKhly(4);
        }
        if (ucName.contains("软齐")) {
            baseCustomInfo.setKhly(6);
        }

        baseCustomInfo.setSjh(json.getString("cluePhoneNumber"));
        baseCustomInfo.setWx(json.getString("wechatAccount"));
        baseCustomInfo.setKhdz(json.getString("areaProvince")+"-"+json.getString("area"));
        baseCustomInfo.setKhxq(json.getString("searchWord"));
        baseCustomInfo.setGjc(json.getString("keyword"));
        baseCustomInfo.setKhzt(1);
        baseCustomInfo.setGs(1);


        String commitTime = json.getString("commitTime");
        baseCustomInfo.setCreateTime(DateUtil.parse(commitTime));
        baseCustomInfo.setUpdateTime(DateUtil.parse(commitTime));
        baseCustomInfo.setCreateBy("SYSTEM");
        baseCustomInfo.setUpdateBy("SYSTEM");
        iBaseCustomInfoService.insertBaseCustomInfo(baseCustomInfo);
        return AjaxResult.success();
    }

    @PostMapping(value = "/fy/msg")
    public AjaxResult fyMsg(@RequestBody JSONObject json) {
        log.info("json=========={}",json.toJSONString());
        BaseCustomInfo baseCustomInfo = new BaseCustomInfo();
        baseCustomInfo.setKhxm(json.getString("name"));
        baseCustomInfo.setKhly(7);

        baseCustomInfo.setSjh(json.getString("telphone"));
        baseCustomInfo.setWx(json.getString("weixin"));
        baseCustomInfo.setKhdz(json.getString("address"));
        baseCustomInfo.setKhxq(json.getString("remark"));
        baseCustomInfo.setGjc("无");
        baseCustomInfo.setKhzt(1);
        baseCustomInfo.setGs(1);


        String commitTime = json.getString("create_time");
        Instant instant = Instant.ofEpochSecond(Long.parseLong(commitTime));
        baseCustomInfo.setCreateTime(Date.from(instant));
        baseCustomInfo.setUpdateTime(Date.from(instant));
        baseCustomInfo.setCreateBy("SYSTEM");
        baseCustomInfo.setUpdateBy("SYSTEM");
        iBaseCustomInfoService.insertBaseCustomInfo(baseCustomInfo);
        return AjaxResult.success();
    }
}
