package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;
import com.ruoyi.system.service.business.IBaseContractPeriodsInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 合同期限Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/contractPeriods/info")
public class BaseContractPeriodsInfoController extends BaseController
{
    @Autowired
    private IBaseContractPeriodsInfoService baseContractPeriodsInfoService;

    /**
     * 查询合同期限列表
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        startPage();
        List<BaseContractPeriodsInfo> list = baseContractPeriodsInfoService.selectBaseContractPeriodsInfoList(baseContractPeriodsInfo);
        return getDataTable(list);
    }

    /**
     * 导出合同期限列表
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:export')")
    @Log(title = "合同期限", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        List<BaseContractPeriodsInfo> list = baseContractPeriodsInfoService.selectBaseContractPeriodsInfoList(baseContractPeriodsInfo);
        ExcelUtil<BaseContractPeriodsInfo> util = new ExcelUtil<BaseContractPeriodsInfo>(BaseContractPeriodsInfo.class);
        util.exportExcel(response, list, "合同期限数据");
    }

    /**
     * 获取合同期限详细信息
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseContractPeriodsInfoService.selectBaseContractPeriodsInfoById(id));
    }

    /**
     * 新增合同期限
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:add')")
    @Log(title = "合同期限", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        return toAjax(baseContractPeriodsInfoService.insertBaseContractPeriodsInfo(baseContractPeriodsInfo));
    }

    /**
     * 修改合同期限
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:edit')")
    @Log(title = "合同期限", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        return toAjax(baseContractPeriodsInfoService.updateBaseContractPeriodsInfo(baseContractPeriodsInfo));
    }

    /**
     * 删除合同期限
     */
    // @PreAuthorize("@ss.hasPermi('contractPeriods:info:remove')")
    @Log(title = "合同期限", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseContractPeriodsInfoService.deleteBaseContractPeriodsInfoByIds(ids));
    }
}
