package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BasePaymentCollectionInfo;
import com.ruoyi.system.service.business.IBasePaymentCollectionInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 回款信息Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/paymentCollection/info")
public class BasePaymentCollectionInfoController extends BaseController
{
    @Autowired
    private IBasePaymentCollectionInfoService basePaymentCollectionInfoService;

    /**
     * 查询回款信息列表
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BasePaymentCollectionInfo basePaymentCollectionInfo)
    {
        startPage();
        List<BasePaymentCollectionInfo> list = basePaymentCollectionInfoService.selectBasePaymentCollectionInfoList(basePaymentCollectionInfo);
        return getDataTable(list);
    }

    /**
     * 导出回款信息列表
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:export')")
    @Log(title = "回款信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BasePaymentCollectionInfo basePaymentCollectionInfo)
    {
        List<BasePaymentCollectionInfo> list = basePaymentCollectionInfoService.selectBasePaymentCollectionInfoList(basePaymentCollectionInfo);
        ExcelUtil<BasePaymentCollectionInfo> util = new ExcelUtil<BasePaymentCollectionInfo>(BasePaymentCollectionInfo.class);
        util.exportExcel(response, list, "回款信息数据");
    }

    /**
     * 获取回款信息详细信息
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(basePaymentCollectionInfoService.selectBasePaymentCollectionInfoById(id));
    }

    /**
     * 新增回款信息
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:add')")
    @Log(title = "回款信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BasePaymentCollectionInfo basePaymentCollectionInfo)
    {
        return toAjax(basePaymentCollectionInfoService.insertBasePaymentCollectionInfo(basePaymentCollectionInfo));
    }

    /**
     * 修改回款信息
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:edit')")
    @Log(title = "回款信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BasePaymentCollectionInfo basePaymentCollectionInfo)
    {
        return toAjax(basePaymentCollectionInfoService.updateBasePaymentCollectionInfo(basePaymentCollectionInfo));
    }

    /**
     * 删除回款信息
     */
    // @PreAuthorize("@ss.hasPermi('paymentCollection:info:remove')")
    @Log(title = "回款信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(basePaymentCollectionInfoService.deleteBasePaymentCollectionInfoByIds(ids));
    }
}
