package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseContractAuditRecord;
import com.ruoyi.system.service.business.IBaseContractAuditRecordService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 合同审核记录Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/contractAudit/record")
public class BaseContractAuditRecordController extends BaseController
{
    @Autowired
    private IBaseContractAuditRecordService baseContractAuditRecordService;

    /**
     * 查询合同审核记录列表
     */
    // // @PreAuthorize("@ss.hasPermi('contractAudit:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseContractAuditRecord baseContractAuditRecord)
    {
        startPage();
        List<BaseContractAuditRecord> list = baseContractAuditRecordService.selectBaseContractAuditRecordList(baseContractAuditRecord);
        return getDataTable(list);
    }

    /**
     * 导出合同审核记录列表
     */
    //  // @PreAuthorize("@ss.hasPermi('contractAudit:record:export')")
    @Log(title = "合同审核记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseContractAuditRecord baseContractAuditRecord)
    {
        List<BaseContractAuditRecord> list = baseContractAuditRecordService.selectBaseContractAuditRecordList(baseContractAuditRecord);
        ExcelUtil<BaseContractAuditRecord> util = new ExcelUtil<BaseContractAuditRecord>(BaseContractAuditRecord.class);
        util.exportExcel(response, list, "合同审核记录数据");
    }

    /**
     * 获取合同审核记录详细信息
     */
    //  // @PreAuthorize("@ss.hasPermi('contractAudit:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseContractAuditRecordService.selectBaseContractAuditRecordById(id));
    }

    /**
     * 新增合同审核记录
     */
    //  // @PreAuthorize("@ss.hasPermi('contractAudit:record:add')")
    @Log(title = "合同审核记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseContractAuditRecord baseContractAuditRecord)
    {
        return toAjax(baseContractAuditRecordService.insertBaseContractAuditRecord(baseContractAuditRecord));
    }

    /**
     * 修改合同审核记录
     */
    // // @PreAuthorize("@ss.hasPermi('contractAudit:record:edit')")
    @Log(title = "合同审核记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseContractAuditRecord baseContractAuditRecord)
    {
        return toAjax(baseContractAuditRecordService.updateBaseContractAuditRecord(baseContractAuditRecord));
    }

    /**
     * 删除合同审核记录
     */
    //  // @PreAuthorize("@ss.hasPermi('contractAudit:record:remove')")
    @Log(title = "合同审核记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseContractAuditRecordService.deleteBaseContractAuditRecordByIds(ids));
    }
}
