package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 开票信息对象 base_invoice_info
 *
 * @author gm
 * @date 2025-02-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseInvoiceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 合同编号 */
    @Excel(name = "合同编号")
    private String htbh;

    /** 部门id */
    @Excel(name = "部门id")
    private Long bmId;

    /** 部门 */
    @Excel(name = "部门")
    private String bm;

    /** 客户id */
    @Excel(name = "客户id")
    private Long khId;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String khmc;

    /** 合同名称 */
    @Excel(name = "合同名称")
    private String htmc;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 回款期数 */
    @Excel(name = "回款期数")
    private Long hkqs;

    /** 发票内容 */
    @Excel(name = "发票内容")
    private String fpnr;

    /** 发票类型 */
    @Excel(name = "发票类型")
    private Long fplx;

    /** 发票税率 */
    @Excel(name = "发票税率")
    private BigDecimal fpsl;

    /** 开票金额 */
    @Excel(name = "开票金额")
    private BigDecimal kpje;

    /** 发票税额 */
    @Excel(name = "发票税额")
    private BigDecimal fpse;

    /** 纳税人识别号 */
    @Excel(name = "纳税人识别号")
    private String nsrsbh;

    /** 发票代码 */
    @Excel(name = "发票代码")
    private String fpdm;

    /** 发票号码 */
    @Excel(name = "发票号码")
    private String fphm;

    /** 地址 */
    @Excel(name = "地址")
    private String dz;

    /** 手机号 */
    @Excel(name = "手机号")
    private String sjh;

    /** 开户行 */
    @Excel(name = "开户行")
    private String khh;

    /** 银行账号 */
    @Excel(name = "银行账号")
    private String yhzh;

    /** 收票人姓名 */
    @Excel(name = "收票人姓名")
    private String sprxm;

    /** 收票人电话 */
    @Excel(name = "收票人电话")
    private String sprdh;

    /** 收票人邮箱 */
    @Excel(name = "收票人邮箱")
    private String spryx;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 发票状态 1 待审核 2 驳回 3 审核通过 3 已冲红 */
    @Excel(name = "发票状态 1 待审核 2 驳回 3 审核通过 4 已冲红")
    private Long fpzt;

    /** 申请人 */
    @Excel(name = "申请人")
    private String sqr;

    /** 审核人id */
    private Long shrId;

    /** 审核人 */
    private String shrName;

    /** 开票时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开票时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date kpsj;

    /** 代付款协议 */
    @Excel(name = "代付款协议")
    private String dfkxy;

    /** 电子回单 */
    @Excel(name = "电子回单")
    private String dzhd;

    /** 发票附件 */
    @Excel(name = "发票附件")
    private String fpfj;

    private List<BaseInvoiceAuditRecord> baseInvoiceAuditRecords;
}
