package com.ruoyi.system.domain.business;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 客户信息对象 base_custom_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseCustomInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 客户姓名 */
    @Excel(name = "客户姓名")
    private String khxm;

    /** 客户公司 */
    @Excel(name = "客户公司")
    private String khgs;

    /** 客户类型 */
    @Excel(name = "客户类型")
    private Long khly;

    /** 产品类别 */
    @Excel(name = "产品类别")
    private Long cplb;

    /** 手机号 */
    @Excel(name = "手机号")
    private String sjh;

    /** 微信 */
    @Excel(name = "微信")
    private String wx;

    /** 客户地址 */
    @Excel(name = "客户地址")
    private String khdz;

    /** 客户需求描述 */
    @Excel(name = "客户需求描述")
    private String khxq;

    /** 客户行业 */
    @Excel(name = "客户行业")
    private String khhy;

    /** 意向等级 */
    @Excel(name = "意向等级")
    private Long yxdj;

    /** 客户状态 */
    @Excel(name = "客户状态")
    private Long khzt;

    /** 归属 1 个人 2 部门 */
    @Excel(name = "归属 1 个人 2 部门")
    private Integer gs;

    /** 归属id */
    @Excel(name = "归属id")
    private Long gsId;

    /** 负责人 */
    @Excel(name = "负责人")
    private String fzr;



    /** 标签 */
    @Excel(name = "标签")
    private String bq;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 是否删除 1 删除 0 正常 */
    @Excel(name = "是否删除 1 删除 0 正常")
    private Long deleteFlag;

    private String[] customTrade;

    private String[] customStatus;

    private String[] purposeLevel;

    private String[] productType;

    private String[] customSource;

    private Date startTime;

    private Date endTime;

    private Integer rubbishFlag;

}
