package com.ruoyi.system.domain.business;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 主体信息对象 base_subject_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseSubjectInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 主题名称 */
    @Excel(name = "主题名称")
    private String ztmc;

    /** 识别号 */
    @Excel(name = "识别号")
    private String sbh;

    /** 法人 */
    @Excel(name = "法人")
    private String fr;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String lxdh;

    /** 邮箱 */
    @Excel(name = "邮箱")
    private String yx;

    /** 地址 */
    @Excel(name = "地址")
    private String dz;

    /** 开户行 */
    @Excel(name = "开户行")
    private String khh;

    /** 行号 */
    @Excel(name = "行号")
    private String hh;

    /** 银行账号 */
    @Excel(name = "银行账号")
    private String yhzh;

    /** 是否删除 1 是 0 否 */
    @Excel(name = "是否删除 1 是 0 否")
    private Long deleteFlag;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    private String contractPrefix;
}
