package com.ruoyi.system.domain.business;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 客户信息对象 base_custom_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseCustomInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 客户姓名 */
    @Excel(name = "客户姓名")
    private String khxm;

    /** 客户公司 */
    @Excel(name = "客户公司")
    private String khgs;

    /** 客户类型 */
    @Excel(name = "客户来源" ,readConverterExp = "1=软艺,2=软通,3=网联,4=软盈,5=渠道")
    private Long khly;

    /** 产品类别 */
    @Excel(name = "产品类别",readConverterExp = "1=APP,2=PC,3=小程序,4=H5")
    private Long cplb;

    /** 手机号 */
    @Excel(name = "手机号")
    private String sjh;

    /** 微信 */
    @Excel(name = "微信")
    private String wx;

    /** 客户地址 */
    @Excel(name = "客户地址")
    private String khdz;

    /** 客户需求描述 */
    @Excel(name = "客户需求描述")
    private String khxq;

    /** 客户行业 */
    @Excel(name = "客户行业",readConverterExp = "1=农林牧渔,2=采矿业,3=制造业,4=水电燃气,5=建筑业,6=批发零售,7=交通运输,8=住宿餐饮,9=互联网,10=房地产业,11=商务服务,12=科技服务,13=居民服务,14=水利公共,15=公共卫生,16=文体娱乐,17=公共机构,18=国际组织,19=其他,20=教育培训")
    private String khhy;

    /** 意向等级 */
    @Excel(name = "意向等级",readConverterExp = "1=无意向,2=低意向,3=高意向" )
    private Long yxdj;

    /** 客户状态 */
    @Excel(name = "客户状态" ,readConverterExp = "1=未联系,2=已上门,3=已电话,4=已微信,5=已成交,6=已签合同,7=已终止,8=商务谈判")
    private Long khzt;

    /** 归属 1 个人 2 部门 */
    //@Excel(name = "归属 1 个人 2 部门")
    private Integer gs;

    /** 归属id */
    //@Excel(name = "归属id")
    private Long gsId;

    /** 负责人 */
    @Excel(name = "负责人")
    private String fzr;



    /** 标签 */
    @Excel(name = "标签",readConverterExp  = "1=预算低,2=个人,3=公司,4=有实力,5=预算一般,6=预算高,7=比价,8=找本地,9=未接通")
    private String bq;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 是否删除 1 删除 0 正常 */
    // @Excel(name = "是否删除 1 删除 0 正常")
    private Long deleteFlag;

    private String[] customTrade;

    private String[] customStatus;

    private String[] purposeLevel;

    private String[] productType;

    private String[] customSource;

    private Date startTime;

    private Date endTime;

    private Integer rubbishFlag;

}
