package com.ruoyi.system.service.business.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BasePerformanceCompleteInfo;
import com.ruoyi.system.domain.business.vo.PerformanceCompleteVo;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.mapper.business.BasePerformanceCompleteInfoMapper;
import com.ruoyi.system.service.business.IBasePerformanceCompleteInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 业绩目标Service业务层处理
 *
 * @author gm
 * @date 2025-06-06
 */
@Service
public class BasePerformanceCompleteInfoServiceImpl implements IBasePerformanceCompleteInfoService
{
    @Autowired
    private BasePerformanceCompleteInfoMapper basePerformanceCompleteInfoMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查询业绩目标
     *
     * @param id 业绩目标主键
     * @return 业绩目标
     */
    @Override
    public BasePerformanceCompleteInfo selectBasePerformanceCompleteInfoById(Long id)
    {
        return basePerformanceCompleteInfoMapper.selectBasePerformanceCompleteInfoById(id);
    }

    /**
     * 查询业绩目标列表
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 业绩目标
     */
    @Override
    public List<PerformanceCompleteVo> selectBasePerformanceCompleteInfoList(BasePerformanceCompleteInfo basePerformanceCompleteInfo)
    {
        List<PerformanceCompleteVo> performanceCompleteResult = new ArrayList<>();
        List<BasePerformanceCompleteInfo> basePerformanceCompleteInfos = basePerformanceCompleteInfoMapper.selectBasePerformanceCompleteInfoList(basePerformanceCompleteInfo);

        Map<String, List<BasePerformanceCompleteInfo>> groupedByDepartment = basePerformanceCompleteInfos.stream()
                .collect(Collectors.groupingBy(BasePerformanceCompleteInfo::getUserName));

        for (String key : groupedByDepartment.keySet()) {
            List<BasePerformanceCompleteInfo> basePerformanceCompleteInfos1 = groupedByDepartment.get(key);
            PerformanceCompleteVo performanceCompleteVo = new PerformanceCompleteVo();
            performanceCompleteVo.setTargetType(basePerformanceCompleteInfos1.get(0).getTargetType());
            performanceCompleteVo.setUserName(basePerformanceCompleteInfos1.get(0).getUserName());
            SysUser sysUser = sysUserMapper.selectUserById(basePerformanceCompleteInfos1.get(0).getUserId());
            performanceCompleteVo.setDeptName(sysUser.getDept().getDeptName());
            performanceCompleteVo.setYear(basePerformanceCompleteInfos1.get(0).getYear());

            List<PerformanceCompleteVo.PerformanceMonth> months = new ArrayList<>();
            for (BasePerformanceCompleteInfo performanceCompleteInfo : basePerformanceCompleteInfos1) {
                PerformanceCompleteVo.PerformanceMonth perfMonth = new PerformanceCompleteVo.PerformanceMonth();
                perfMonth.setId(performanceCompleteInfo.getId());
                perfMonth.setComplete(performanceCompleteInfo.getComplete());
                perfMonth.setMonth(performanceCompleteInfo.getMonth());
                perfMonth.setTarget(performanceCompleteInfo.getTarget());
                perfMonth.setCompleteRate(performanceCompleteInfo.getCompleteRate());
                months.add(perfMonth);
            }
            performanceCompleteVo.setMonthData(months);
            performanceCompleteResult.add(performanceCompleteVo);
        }

        return performanceCompleteResult;
    }

    /**
     * 新增业绩目标
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 结果
     */
    @Override
    public int insertBasePerformanceCompleteInfo(BasePerformanceCompleteInfo basePerformanceCompleteInfo)
    {
        basePerformanceCompleteInfo.setCreateTime(DateUtils.getNowDate());
        return basePerformanceCompleteInfoMapper.insertBasePerformanceCompleteInfo(basePerformanceCompleteInfo);
    }

    /**
     * 修改业绩目标
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 结果
     */
    @Override
    public void updateBasePerformanceCompleteInfo(PerformanceCompleteVo performanceCompleteVo)
    {
        List<PerformanceCompleteVo.PerformanceMonth> monthData = performanceCompleteVo.getMonthData();
        if (ObjectUtil.isNotEmpty(monthData)) {
            for (PerformanceCompleteVo.PerformanceMonth monthDatum : monthData) {
                BasePerformanceCompleteInfo basePerformanceCompleteInfo = new BasePerformanceCompleteInfo();
                BeanUtil.copyProperties(monthDatum,basePerformanceCompleteInfo);
                basePerformanceCompleteInfoMapper.updateBasePerformanceCompleteInfo(basePerformanceCompleteInfo);
            }
        }
    }

    /**
     * 批量删除业绩目标
     *
     * @param ids 需要删除的业绩目标主键
     * @return 结果
     */
    @Override
    public int deleteBasePerformanceCompleteInfoByIds(Long[] ids)
    {
        return basePerformanceCompleteInfoMapper.deleteBasePerformanceCompleteInfoByIds(ids);
    }

    /**
     * 删除业绩目标信息
     *
     * @param id 业绩目标主键
     * @return 结果
     */
    @Override
    public int deleteBasePerformanceCompleteInfoById(Long id)
    {
        return basePerformanceCompleteInfoMapper.deleteBasePerformanceCompleteInfoById(id);
    }

    @Override
    public List<BasePerformanceCompleteInfo> selectBasePerformanceCompleteInfos(BasePerformanceCompleteInfo basePerformanceCompleteInfo) {
        return basePerformanceCompleteInfoMapper.selectBasePerformanceCompleteInfoList(basePerformanceCompleteInfo);
    }
}
