package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseInvoiceAuditRecord;
import com.ruoyi.system.mapper.business.BaseInvoiceAuditRecordMapper;
import com.ruoyi.system.service.business.IBaseInvoiceAuditRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 发票审批记录Service业务层处理
 *
 * @author gm
 * @date 2025-02-25
 */
@Service
public class BaseInvoiceAuditRecordServiceImpl implements IBaseInvoiceAuditRecordService
{
    @Autowired
    private BaseInvoiceAuditRecordMapper baseInvoiceAuditRecordMapper;

    /**
     * 查询发票审批记录
     *
     * @param id 发票审批记录主键
     * @return 发票审批记录
     */
    @Override
    public BaseInvoiceAuditRecord selectBaseInvoiceAuditRecordById(Long id)
    {
        return baseInvoiceAuditRecordMapper.selectBaseInvoiceAuditRecordById(id);
    }

    /**
     * 查询发票审批记录列表
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 发票审批记录
     */
    @Override
    public List<BaseInvoiceAuditRecord> selectBaseInvoiceAuditRecordList(BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        return baseInvoiceAuditRecordMapper.selectBaseInvoiceAuditRecordList(baseInvoiceAuditRecord);
    }

    /**
     * 新增发票审批记录
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 结果
     */
    @Override
    public int insertBaseInvoiceAuditRecord(BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        baseInvoiceAuditRecord.setCreateTime(DateUtils.getNowDate());
        return baseInvoiceAuditRecordMapper.insertBaseInvoiceAuditRecord(baseInvoiceAuditRecord);
    }

    /**
     * 修改发票审批记录
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 结果
     */
    @Override
    public int updateBaseInvoiceAuditRecord(BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        return baseInvoiceAuditRecordMapper.updateBaseInvoiceAuditRecord(baseInvoiceAuditRecord);
    }

    /**
     * 批量删除发票审批记录
     *
     * @param ids 需要删除的发票审批记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseInvoiceAuditRecordByIds(Long[] ids)
    {
        return baseInvoiceAuditRecordMapper.deleteBaseInvoiceAuditRecordByIds(ids);
    }

    /**
     * 删除发票审批记录信息
     *
     * @param id 发票审批记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseInvoiceAuditRecordById(Long id)
    {
        return baseInvoiceAuditRecordMapper.deleteBaseInvoiceAuditRecordById(id);
    }
}
