package com.ruoyi.system.domain.business.vo;

import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 业绩目标对象 base_performance_complete_info
 *
 * @author gm
 * @date 2025-06-06
 */
@Data
public class PerformanceCompleteVo extends BaseEntity
{

    /** 目标类型 1 个人 2 公司 */
    private Integer targetType;

    /** 用户名 */
    private String userName;

    // 部门名称
    private String deptName;

    /** 年份 */
    private Integer year;

    private List<PerformanceMonth> monthData;

    @Data
    public static class PerformanceMonth {

        private Long id;

        /** 月份 */
        private Integer month;

        /** 目标 */
        private BigDecimal target;

        /** 已完成 */
        private BigDecimal complete;

        /** 完成率 */
        private BigDecimal completeRate;
    }

}

