package com.ruoyi.system.domain.business;

import java.math.BigDecimal;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 业绩目标对象 base_performance_complete_info
 *
 * @author gm
 * @date 2025-06-06
 */
@Data
public class BasePerformanceCompleteInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 目标类型 1 个人 2 公司 */
    @Excel(name = "目标类型 1 个人 2 公司")
    private Integer targetType;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 用户名 */
    @Excel(name = "用户名")
    private String userName;

    /** 年份 */
    @Excel(name = "年份")
    private Integer year;

    /** 月份 */
    @Excel(name = "月份")
    private Integer month;

    /** 目标 */
    @Excel(name = "目标")
    private BigDecimal target;

    /** 已完成 */
    @Excel(name = "已完成")
    private BigDecimal complete;

    /** 完成率 */
    @Excel(name = "完成率")
    private BigDecimal completeRate;

}
