package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseInvoiceInfo;
import com.ruoyi.system.mapper.business.BaseInvoiceInfoMapper;
import com.ruoyi.system.service.business.IBaseInvoiceInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 开票信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-17
 */
@Service
public class BaseInvoiceInfoServiceImpl implements IBaseInvoiceInfoService
{
    @Autowired
    private BaseInvoiceInfoMapper baseInvoiceInfoMapper;

    /**
     * 查询开票信息
     *
     * @param id 开票信息主键
     * @return 开票信息
     */
    @Override
    public BaseInvoiceInfo selectBaseInvoiceInfoById(Long id)
    {
        return baseInvoiceInfoMapper.selectBaseInvoiceInfoById(id);
    }

    /**
     * 查询开票信息列表
     *
     * @param baseInvoiceInfo 开票信息
     * @return 开票信息
     */
    @Override
    public List<BaseInvoiceInfo> selectBaseInvoiceInfoList(BaseInvoiceInfo baseInvoiceInfo)
    {
        return baseInvoiceInfoMapper.selectBaseInvoiceInfoList(baseInvoiceInfo);
    }

    /**
     * 新增开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @return 结果
     */
    @Override
    public int insertBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo)
    {
        baseInvoiceInfo.setCreateTime(DateUtils.getNowDate());
        return baseInvoiceInfoMapper.insertBaseInvoiceInfo(baseInvoiceInfo);
    }

    /**
     * 修改开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @return 结果
     */
    @Override
    public int updateBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo)
    {
        baseInvoiceInfo.setUpdateTime(DateUtils.getNowDate());
        return baseInvoiceInfoMapper.updateBaseInvoiceInfo(baseInvoiceInfo);
    }

    /**
     * 批量删除开票信息
     *
     * @param ids 需要删除的开票信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseInvoiceInfoByIds(Long[] ids)
    {
        return baseInvoiceInfoMapper.deleteBaseInvoiceInfoByIds(ids);
    }

    /**
     * 删除开票信息信息
     *
     * @param id 开票信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseInvoiceInfoById(Long id)
    {
        return baseInvoiceInfoMapper.deleteBaseInvoiceInfoById(id);
    }
}
