package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BaseInvoiceInfo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 开票信息Mapper接口
 *
 * @author gm
 * @date 2025-02-17
 */
public interface BaseInvoiceInfoMapper
{
    /**
     * 查询开票信息
     *
     * @param id 开票信息主键
     * @return 开票信息
     */
    public BaseInvoiceInfo selectBaseInvoiceInfoById(Long id);

    /**
     * 查询开票信息列表
     *
     * @param baseInvoiceInfo 开票信息
     * @return 开票信息集合
     */
    public List<BaseInvoiceInfo> selectBaseInvoiceInfoList(BaseInvoiceInfo baseInvoiceInfo);

    /**
     * 新增开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @return 结果
     */
    public int insertBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo);

    /**
     * 修改开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @return 结果
     */
    public int updateBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo);

    /**
     * 删除开票信息
     *
     * @param id 开票信息主键
     * @return 结果
     */
    public int deleteBaseInvoiceInfoById(Long id);

    /**
     * 批量删除开票信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBaseInvoiceInfoByIds(Long[] ids);

    BigDecimal queryInvoiceAmount();

}
