package com.ruoyi.system.service.business;

import com.ruoyi.system.domain.business.BaseContractAuditRecord;

import java.util.List;

/**
 * 合同审核记录Service接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface IBaseContractAuditRecordService
{
    /**
     * 查询合同审核记录
     *
     * @param id 合同审核记录主键
     * @return 合同审核记录
     */
    public BaseContractAuditRecord selectBaseContractAuditRecordById(Long id);

    /**
     * 查询合同审核记录列表
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 合同审核记录集合
     */
    public List<BaseContractAuditRecord> selectBaseContractAuditRecordList(BaseContractAuditRecord baseContractAuditRecord);

    /**
     * 新增合同审核记录
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 结果
     */
    public int insertBaseContractAuditRecord(BaseContractAuditRecord baseContractAuditRecord);

    /**
     * 修改合同审核记录
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 结果
     */
    public int updateBaseContractAuditRecord(BaseContractAuditRecord baseContractAuditRecord);

    /**
     * 批量删除合同审核记录
     *
     * @param ids 需要删除的合同审核记录主键集合
     * @return 结果
     */
    public int deleteBaseContractAuditRecordByIds(Long[] ids);

    /**
     * 删除合同审核记录信息
     *
     * @param id 合同审核记录主键
     * @return 结果
     */
    public int deleteBaseContractAuditRecordById(Long id);
}
