package com.ruoyi.system.service.business;

import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;

import java.util.List;

/**
 * 合同期限Service接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface IBaseContractPeriodsInfoService
{
    /**
     * 查询合同期限
     *
     * @param id 合同期限主键
     * @return 合同期限
     */
    public BaseContractPeriodsInfo selectBaseContractPeriodsInfoById(Long id);

    /**
     * 查询合同期限列表
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 合同期限集合
     */
    public List<BaseContractPeriodsInfo> selectBaseContractPeriodsInfoList(BaseContractPeriodsInfo baseContractPeriodsInfo);

    /**
     * 新增合同期限
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 结果
     */
    public int insertBaseContractPeriodsInfo(BaseContractPeriodsInfo baseContractPeriodsInfo);

    /**
     * 修改合同期限
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 结果
     */
    public int updateBaseContractPeriodsInfo(BaseContractPeriodsInfo baseContractPeriodsInfo);

    /**
     * 批量删除合同期限
     *
     * @param ids 需要删除的合同期限主键集合
     * @return 结果
     */
    public int deleteBaseContractPeriodsInfoByIds(Long[] ids);

    /**
     * 删除合同期限信息
     *
     * @param id 合同期限主键
     * @return 结果
     */
    public int deleteBaseContractPeriodsInfoById(Long id);
}
