package com.ruoyi.system.service.business.impl;

import java.util.List;

import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;
import com.ruoyi.system.mapper.business.BaseContractPeriodsInfoMapper;
import com.ruoyi.system.service.business.IBaseContractPeriodsInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 合同期限Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseContractPeriodsInfoServiceImpl implements IBaseContractPeriodsInfoService
{
    @Autowired
    private BaseContractPeriodsInfoMapper baseContractPeriodsInfoMapper;

    /**
     * 查询合同期限
     *
     * @param id 合同期限主键
     * @return 合同期限
     */
    @Override
    public BaseContractPeriodsInfo selectBaseContractPeriodsInfoById(Long id)
    {
        return baseContractPeriodsInfoMapper.selectBaseContractPeriodsInfoById(id);
    }

    /**
     * 查询合同期限列表
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 合同期限
     */
    @Override
    public List<BaseContractPeriodsInfo> selectBaseContractPeriodsInfoList(BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        return baseContractPeriodsInfoMapper.selectBaseContractPeriodsInfoList(baseContractPeriodsInfo);
    }

    /**
     * 新增合同期限
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 结果
     */
    @Override
    public int insertBaseContractPeriodsInfo(BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        return baseContractPeriodsInfoMapper.insertBaseContractPeriodsInfo(baseContractPeriodsInfo);
    }

    /**
     * 修改合同期限
     *
     * @param baseContractPeriodsInfo 合同期限
     * @return 结果
     */
    @Override
    public int updateBaseContractPeriodsInfo(BaseContractPeriodsInfo baseContractPeriodsInfo)
    {
        return baseContractPeriodsInfoMapper.updateBaseContractPeriodsInfo(baseContractPeriodsInfo);
    }

    /**
     * 批量删除合同期限
     *
     * @param ids 需要删除的合同期限主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractPeriodsInfoByIds(Long[] ids)
    {
        return baseContractPeriodsInfoMapper.deleteBaseContractPeriodsInfoByIds(ids);
    }

    /**
     * 删除合同期限信息
     *
     * @param id 合同期限主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractPeriodsInfoById(Long id)
    {
        return baseContractPeriodsInfoMapper.deleteBaseContractPeriodsInfoById(id);
    }
}
