package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseInvoiceAuditRecord;
import com.ruoyi.system.service.business.IBaseInvoiceAuditRecordService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 发票审批记录Controller
 *
 * @author gm
 * @date 2025-02-25
 */
@RestController
@RequestMapping("/system/record")
public class BaseInvoiceAuditRecordController extends BaseController
{
    @Autowired
    private IBaseInvoiceAuditRecordService baseInvoiceAuditRecordService;

    /**
     * 查询发票审批记录列表
     */
    @PreAuthorize("@ss.hasPermi('system:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        startPage();
        List<BaseInvoiceAuditRecord> list = baseInvoiceAuditRecordService.selectBaseInvoiceAuditRecordList(baseInvoiceAuditRecord);
        return getDataTable(list);
    }

    /**
     * 导出发票审批记录列表
     */
    @PreAuthorize("@ss.hasPermi('system:record:export')")
    @Log(title = "发票审批记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        List<BaseInvoiceAuditRecord> list = baseInvoiceAuditRecordService.selectBaseInvoiceAuditRecordList(baseInvoiceAuditRecord);
        ExcelUtil<BaseInvoiceAuditRecord> util = new ExcelUtil<BaseInvoiceAuditRecord>(BaseInvoiceAuditRecord.class);
        util.exportExcel(response, list, "发票审批记录数据");
    }

    /**
     * 获取发票审批记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseInvoiceAuditRecordService.selectBaseInvoiceAuditRecordById(id));
    }

    /**
     * 新增发票审批记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:add')")
    @Log(title = "发票审批记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        return toAjax(baseInvoiceAuditRecordService.insertBaseInvoiceAuditRecord(baseInvoiceAuditRecord));
    }

    /**
     * 修改发票审批记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:edit')")
    @Log(title = "发票审批记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseInvoiceAuditRecord baseInvoiceAuditRecord)
    {
        return toAjax(baseInvoiceAuditRecordService.updateBaseInvoiceAuditRecord(baseInvoiceAuditRecord));
    }

    /**
     * 删除发票审批记录
     */
    @PreAuthorize("@ss.hasPermi('system:record:remove')")
    @Log(title = "发票审批记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseInvoiceAuditRecordService.deleteBaseInvoiceAuditRecordByIds(ids));
    }
}
