package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseCustomInfo;
import com.ruoyi.system.mapper.business.BaseCustomInfoMapper;
import com.ruoyi.system.service.business.IBaseCustomInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 客户信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseCustomInfoServiceImpl implements IBaseCustomInfoService
{
    @Autowired
    private BaseCustomInfoMapper baseCustomInfoMapper;

    /**
     * 查询客户信息
     *
     * @param id 客户信息主键
     * @return 客户信息
     */
    @Override
    public BaseCustomInfo selectBaseCustomInfoById(Long id)
    {
        return baseCustomInfoMapper.selectBaseCustomInfoById(id);
    }

    /**
     * 查询客户信息列表
     *
     * @param baseCustomInfo 客户信息
     * @return 客户信息
     */
    @Override
    public List<BaseCustomInfo> selectBaseCustomInfoList(BaseCustomInfo baseCustomInfo)
    {
        return baseCustomInfoMapper.selectBaseCustomInfoList(baseCustomInfo);
    }

    /**
     * 新增客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    @Override
    public int insertBaseCustomInfo(BaseCustomInfo baseCustomInfo)
    {
        baseCustomInfo.setCreateTime(DateUtils.getNowDate());
        return baseCustomInfoMapper.insertBaseCustomInfo(baseCustomInfo);
    }

    /**
     * 修改客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    @Override
    public int updateBaseCustomInfo(BaseCustomInfo baseCustomInfo)
    {
        baseCustomInfo.setUpdateTime(DateUtils.getNowDate());
        return baseCustomInfoMapper.updateBaseCustomInfo(baseCustomInfo);
    }

    /**
     * 批量删除客户信息
     *
     * @param ids 需要删除的客户信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomInfoByIds(Long[] ids)
    {
        return baseCustomInfoMapper.deleteBaseCustomInfoByIds(ids);
    }

    /**
     * 删除客户信息信息
     *
     * @param id 客户信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomInfoById(Long id)
    {
        return baseCustomInfoMapper.deleteBaseCustomInfoById(id);
    }
}
