package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseCustomInfo;
import com.ruoyi.system.service.business.IBaseCustomInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 客户信息Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/custom/info")
public class BaseCustomInfoController extends BaseController
{
    @Autowired
    private IBaseCustomInfoService baseCustomInfoService;

    /**
     * 查询客户信息列表
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseCustomInfo baseCustomInfo)
    {
        startPage();
        List<BaseCustomInfo> list = baseCustomInfoService.selectBaseCustomInfoList(baseCustomInfo);
        return getDataTable(list);
    }

    /**
     * 导出客户信息列表
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:export')")
    @Log(title = "客户信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseCustomInfo baseCustomInfo)
    {
        List<BaseCustomInfo> list = baseCustomInfoService.selectBaseCustomInfoList(baseCustomInfo);
        ExcelUtil<BaseCustomInfo> util = new ExcelUtil<BaseCustomInfo>(BaseCustomInfo.class);
        util.exportExcel(response, list, "客户信息数据");
    }

    /**
     * 获取客户信息详细信息
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseCustomInfoService.selectBaseCustomInfoById(id));
    }

    /**
     * 新增客户信息
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:add')")
    @Log(title = "客户信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseCustomInfo baseCustomInfo)
    {
        return toAjax(baseCustomInfoService.insertBaseCustomInfo(baseCustomInfo));
    }

    /**
     * 修改客户信息
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:edit')")
    @Log(title = "客户信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseCustomInfo baseCustomInfo)
    {
        return toAjax(baseCustomInfoService.updateBaseCustomInfo(baseCustomInfo));
    }

    /**
     * 删除客户信息
     */
    // @PreAuthorize("@ss.hasPermi('custom:info:remove')")
    @Log(title = "客户信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseCustomInfoService.deleteBaseCustomInfoByIds(ids));
    }
}
