package com.ruoyi.system.domain.business;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 发票审批记录对象 base_invoice_audit_record
 *
 * @author gm
 * @date 2025-02-25
 */
public class BaseInvoiceAuditRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 发票id */
    @Excel(name = "发票id")
    private Long invoiceId;

    /** 审核状态  1 通过 2 拒绝 3 冲红 */
    @Excel(name = "审核状态  1 通过 2 拒绝 3 冲红")
    private Integer shzt;

    /** 审批人 */
    @Excel(name = "审批人")
    private String spr;

    /** 审批时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "审批时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date spTime;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setInvoiceId(Long invoiceId)
    {
        this.invoiceId = invoiceId;
    }

    public Long getInvoiceId()
    {
        return invoiceId;
    }
    public void setShzt(Integer shzt)
    {
        this.shzt = shzt;
    }

    public Integer getShzt()
    {
        return shzt;
    }
    public void setSpr(String spr)
    {
        this.spr = spr;
    }

    public String getSpr()
    {
        return spr;
    }
    public void setSpTime(Date spTime)
    {
        this.spTime = spTime;
    }

    public Date getSpTime()
    {
        return spTime;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("invoiceId", getInvoiceId())
            .append("shzt", getShzt())
            .append("spr", getSpr())
            .append("spTime", getSpTime())
            .append("bz", getBz())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .toString();
    }
}
