package com.ruoyi.system.service.business;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.system.domain.business.BaseInvoiceInfo;

import java.util.List;

/**
 * 开票信息Service接口
 *
 * @author gm
 * @date 2025-02-17
 */
public interface IBaseInvoiceInfoService
{
    /**
     * 查询开票信息
     *
     * @param id 开票信息主键
     * @return 开票信息
     */
    public BaseInvoiceInfo selectBaseInvoiceInfoById(Long id);

    /**
     * 查询开票信息列表
     *
     * @param baseInvoiceInfo 开票信息
     * @return 开票信息集合
     */
    public List<BaseInvoiceInfo> selectBaseInvoiceInfoList(BaseInvoiceInfo baseInvoiceInfo);

    /**
     * 新增开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @return 结果
     */
    public int insertBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo);

    /**
     * 修改开票信息
     *
     * @param baseInvoiceInfo 开票信息
     * @param user
     * @return 结果
     */
    public int updateBaseInvoiceInfo(BaseInvoiceInfo baseInvoiceInfo, SysUser user);

    /**
     * 批量删除开票信息
     *
     * @param ids 需要删除的开票信息主键集合
     * @return 结果
     */
    public int deleteBaseInvoiceInfoByIds(Long[] ids);

    /**
     * 删除开票信息信息
     *
     * @param id 开票信息主键
     * @return 结果
     */
    public int deleteBaseInvoiceInfoById(Long id);

    List<BaseInvoiceInfo> selectBaseInvoiceAuditList(BaseInvoiceInfo baseInvoiceInfo, LoginUser loginUser);
}
