package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BaseCustomInfo;

import java.util.List;

/**
 * 客户信息Mapper接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface BaseCustomInfoMapper
{
    /**
     * 查询客户信息
     *
     * @param id 客户信息主键
     * @return 客户信息
     */
    public BaseCustomInfo selectBaseCustomInfoById(Long id);

    /**
     * 查询客户信息列表
     *
     * @param baseCustomInfo 客户信息
     * @return 客户信息集合
     */
    public List<BaseCustomInfo> selectBaseCustomInfoList(BaseCustomInfo baseCustomInfo);

    /**
     * 新增客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    public int insertBaseCustomInfo(BaseCustomInfo baseCustomInfo);

    /**
     * 修改客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    public int updateBaseCustomInfo(BaseCustomInfo baseCustomInfo);

    /**
     * 删除客户信息
     *
     * @param id 客户信息主键
     * @return 结果
     */
    public int deleteBaseCustomInfoById(Long id);

    /**
     * 批量删除客户信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBaseCustomInfoByIds(Long[] ids);
}
