package com.ruoyi.system.service.business.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseContractInfo;
import com.ruoyi.system.domain.business.BasePaymentCollectionInfo;
import com.ruoyi.system.domain.business.BasePerformanceCompleteInfo;
import com.ruoyi.system.mapper.business.BaseContractInfoMapper;
import com.ruoyi.system.mapper.business.BasePaymentCollectionInfoMapper;
import com.ruoyi.system.mapper.business.BasePerformanceCompleteInfoMapper;
import com.ruoyi.system.service.business.IBasePaymentCollectionInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 回款信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BasePaymentCollectionInfoServiceImpl implements IBasePaymentCollectionInfoService {
    @Autowired
    private BasePaymentCollectionInfoMapper basePaymentCollectionInfoMapper;

    @Autowired
    private BaseContractInfoMapper baseContractInfoMapper;

    @Autowired
    private BasePerformanceCompleteInfoMapper performanceCompleteInfoMapper;

    /**
     * 查询回款信息
     *
     * @param id 回款信息主键
     * @return 回款信息
     */
    @Override
    public BasePaymentCollectionInfo selectBasePaymentCollectionInfoById(Long id) {
        return basePaymentCollectionInfoMapper.selectBasePaymentCollectionInfoById(id);
    }

    /**
     * 查询回款信息列表
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 回款信息
     */
    @Override
    public List<BasePaymentCollectionInfo> selectBasePaymentCollectionInfoList(BasePaymentCollectionInfo basePaymentCollectionInfo) {
        return basePaymentCollectionInfoMapper.selectBasePaymentCollectionInfoList(basePaymentCollectionInfo);
    }

    /**
     * 新增回款信息
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 结果
     */
    @Override
    public int insertBasePaymentCollectionInfo(BasePaymentCollectionInfo basePaymentCollectionInfo) {
        BaseContractInfo baseContractInfo = baseContractInfoMapper.selectBaseContractInfoById(basePaymentCollectionInfo.getContractId());
        if (baseContractInfo != null) {
            if (basePaymentCollectionInfo.getDzFlag() == 1 && basePaymentCollectionInfo.getHkje() != null) {
                BigDecimal hkje = baseContractInfo.getHkje();
                if (hkje == null) {
                    hkje = BigDecimal.ZERO;
                }
                baseContractInfo.setHkje(hkje.add(basePaymentCollectionInfo.getHkje()));
                baseContractInfoMapper.updateBaseContractInfo(baseContractInfo);

                // 处理绩效数据
                BasePerformanceCompleteInfo basePerformanceCompleteInfo = new BasePerformanceCompleteInfo();
                basePerformanceCompleteInfo.setTargetType(1);
                basePerformanceCompleteInfo.setYear(DateUtil.thisYear());
                basePerformanceCompleteInfo.setMonth(DateUtil.thisMonth() + 1);
                basePerformanceCompleteInfo.setUserId(baseContractInfo.getYwyId());
                List<BasePerformanceCompleteInfo> basePerformanceCompleteInfos = performanceCompleteInfoMapper.selectBasePerformanceCompleteInfoList(basePerformanceCompleteInfo);
                if (ObjectUtil.isNotEmpty(basePerformanceCompleteInfos)) {
                    for (BasePerformanceCompleteInfo performanceCompleteInfo : basePerformanceCompleteInfos) {
                        BigDecimal newComplete = performanceCompleteInfo.getComplete().add(hkje);
                        performanceCompleteInfo.setComplete(newComplete);
                        performanceCompleteInfo.setCompleteRate(newComplete.divide(performanceCompleteInfo.getTarget()).multiply(BigDecimal.valueOf(100)).setScale(2, RoundingMode.HALF_UP));
                        performanceCompleteInfoMapper.updateBasePerformanceCompleteInfo(performanceCompleteInfo);
                    }
                }
            }
        }
        basePaymentCollectionInfo.setCreateTime(DateUtils.getNowDate());
        basePaymentCollectionInfo.setUpdateTime(DateUtils.getNowDate());
        return basePaymentCollectionInfoMapper.insertBasePaymentCollectionInfo(basePaymentCollectionInfo);
    }

    /**
     * 修改回款信息
     *
     * @param basePaymentCollectionInfo 回款信息
     * @return 结果
     */
    @Override
    public int updateBasePaymentCollectionInfo(BasePaymentCollectionInfo basePaymentCollectionInfo) {
        basePaymentCollectionInfo.setUpdateTime(DateUtils.getNowDate());
        return basePaymentCollectionInfoMapper.updateBasePaymentCollectionInfo(basePaymentCollectionInfo);
    }

    /**
     * 批量删除回款信息
     *
     * @param ids 需要删除的回款信息主键
     * @return 结果
     */
    @Override
    public int deleteBasePaymentCollectionInfoByIds(Long[] ids) {
        return basePaymentCollectionInfoMapper.deleteBasePaymentCollectionInfoByIds(ids);
    }

    /**
     * 删除回款信息信息
     *
     * @param id 回款信息主键
     * @return 结果
     */
    @Override
    public int deleteBasePaymentCollectionInfoById(Long id) {
        return basePaymentCollectionInfoMapper.deleteBasePaymentCollectionInfoById(id);
    }
}
