package com.ruoyi.system.service.business.impl;

import java.util.List;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseCustomInfo;
import com.ruoyi.system.domain.business.vo.CustomReportVo;
import com.ruoyi.system.domain.business.vo.ThreadReportVo;
import com.ruoyi.system.mapper.business.BaseCustomInfoMapper;
import com.ruoyi.system.service.business.IBaseCustomInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 客户信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseCustomInfoServiceImpl implements IBaseCustomInfoService {
    @Autowired
    private BaseCustomInfoMapper baseCustomInfoMapper;

    /**
     * 查询客户信息
     *
     * @param id 客户信息主键
     * @return 客户信息
     */
    @Override
    public BaseCustomInfo selectBaseCustomInfoById(Long id) {
        return baseCustomInfoMapper.selectBaseCustomInfoById(id);
    }

    /**
     * 查询客户信息列表
     *
     * @param baseCustomInfo 客户信息
     * @return 客户信息
     */
    @Override
    public List<BaseCustomInfo> selectBaseCustomInfoList(BaseCustomInfo baseCustomInfo) {
        if (baseCustomInfo.getEndTime() != null) {
            baseCustomInfo.setEndTime(DateUtils.addDays(baseCustomInfo.getEndTime(),1));
        }
        return baseCustomInfoMapper.selectBaseCustomInfoList(baseCustomInfo);
    }

    /**
     * 新增客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    @Override
    public int insertBaseCustomInfo(BaseCustomInfo baseCustomInfo) {
        baseCustomInfo.setCreateTime(DateUtils.getNowDate());
        baseCustomInfo.setKhgs(baseCustomInfo.getKhgs() == null ? "未知" : baseCustomInfo.getKhgs());
        baseCustomInfo.setKhgs(baseCustomInfo.getKhxm() == null ? "未知" : baseCustomInfo.getKhxm());
        return baseCustomInfoMapper.insertBaseCustomInfo(baseCustomInfo);
    }

    /**
     * 修改客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    @Override
    public int updateBaseCustomInfo(BaseCustomInfo baseCustomInfo) {
        baseCustomInfo.setUpdateTime(DateUtils.getNowDate());
        return baseCustomInfoMapper.updateBaseCustomInfo(baseCustomInfo);
    }

    /**
     * 批量删除客户信息
     *
     * @param ids 需要删除的客户信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomInfoByIds(Long[] ids) {
        return baseCustomInfoMapper.deleteBaseCustomInfoByIds(ids);
    }

    /**
     * 删除客户信息信息
     *
     * @param id 客户信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomInfoById(Long id) {
        return baseCustomInfoMapper.deleteBaseCustomInfoById(id);
    }

    @Override
    public List<ThreadReportVo> threadReport(Integer periodType, String subjectName) {
        Integer khly = null;

        if (ObjectUtil.isNotEmpty(subjectName) ) {
            if (subjectName.contains("软艺")) {
                khly = 1;
            }
            if (subjectName.contains("软通")) {
                khly = 2;
            }
            if (subjectName.contains("网联")) {
                khly = 3;
            }
            if (subjectName.contains("软盈")) {
                khly = 4;
            }
            if (subjectName.contains("软齐")) {
                khly = 6;
            }
        }
        return baseCustomInfoMapper.threadReport(periodType,khly);
    }

    @Override
    public List<CustomReportVo> customReport(String subjectName) {
        Integer khly = null;

        if (ObjectUtil.isNotEmpty(subjectName) ) {
            if (subjectName.contains("软艺")) {
                khly = 1;
            }
            if (subjectName.contains("软通")) {
                khly = 2;
            }
            if (subjectName.contains("网联")) {
                khly = 3;
            }
            if (subjectName.contains("软盈")) {
                khly = 4;
            }
            if (subjectName.contains("软齐")) {
                khly = 6;
            }
        }
        return baseCustomInfoMapper.customReport(khly);
    }
}
