package com.ruoyi.system.service.business;

import com.ruoyi.system.domain.business.BaseCustomInfo;
import com.ruoyi.system.domain.business.vo.CustomReportVo;
import com.ruoyi.system.domain.business.vo.ThreadReportVo;

import java.util.List;

/**
 * 客户信息Service接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface IBaseCustomInfoService
{
    /**
     * 查询客户信息
     *
     * @param id 客户信息主键
     * @return 客户信息
     */
    public BaseCustomInfo selectBaseCustomInfoById(Long id);

    /**
     * 查询客户信息列表
     *
     * @param baseCustomInfo 客户信息
     * @return 客户信息集合
     */
    public List<BaseCustomInfo> selectBaseCustomInfoList(BaseCustomInfo baseCustomInfo);

    /**
     * 新增客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    public int insertBaseCustomInfo(BaseCustomInfo baseCustomInfo);

    /**
     * 修改客户信息
     *
     * @param baseCustomInfo 客户信息
     * @return 结果
     */
    public int updateBaseCustomInfo(BaseCustomInfo baseCustomInfo);

    /**
     * 批量删除客户信息
     *
     * @param ids 需要删除的客户信息主键集合
     * @return 结果
     */
    public int deleteBaseCustomInfoByIds(Long[] ids);

    /**
     * 删除客户信息信息
     *
     * @param id 客户信息主键
     * @return 结果
     */
    public int deleteBaseCustomInfoById(Long id);

    List<ThreadReportVo> threadReport(Integer periodType, String subjectName);

    List<CustomReportVo> customReport(String subjectName);
}
