package com.ruoyi.system.service.business;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.system.domain.business.BaseContractInfo;
import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;
import com.ruoyi.system.domain.business.vo.ContractCollectVo;
import com.ruoyi.system.domain.business.vo.RateOfReportVo;
import com.ruoyi.system.domain.business.vo.SignAmountReportVo;
import com.ruoyi.system.domain.business.vo.TotalReportVo;

import java.util.List;

/**
 * 合同信息Service接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface IBaseContractInfoService
{
    /**
     * 查询合同信息
     *
     * @param id 合同信息主键
     * @return 合同信息
     */
    public BaseContractInfo selectBaseContractInfoById(Long id);

    /**
     * 查询合同信息列表
     *
     * @param baseContractInfo 合同信息
     * @return 合同信息集合
     */
    public List<BaseContractInfo> selectBaseContractInfoList(BaseContractInfo baseContractInfo);

    /**
     * 新增合同信息
     *
     * @param baseContractInfo 合同信息
     * @return 结果
     */
    public int insertBaseContractInfo(BaseContractInfo baseContractInfo);

    /**
     * 修改合同信息
     *
     * @param baseContractInfo 合同信息
     * @param user
     * @return 结果
     */
    public int updateBaseContractInfo(BaseContractInfo baseContractInfo, SysUser user);

    /**
     * 批量删除合同信息
     *
     * @param ids 需要删除的合同信息主键集合
     * @return 结果
     */
    public int deleteBaseContractInfoByIds(Long[] ids);

    /**
     * 删除合同信息信息
     *
     * @param id 合同信息主键
     * @return 结果
     */
    public int deleteBaseContractInfoById(Long id);

    List<BaseContractInfo> selectBaseContractAuditList(BaseContractInfo baseContractInfo, LoginUser loginUser);

    ContractCollectVo getCollect(Long contractId);

    List<BaseContractPeriodsInfo> getPeriodInfo(BaseContractInfo baseContractInfo);

    TotalReportVo totalReport(Integer periodType,Integer subjectId);

    List<SignAmountReportVo> signAmountReport(Integer subjectId, Integer year, Long userId);

    List<RateOfReportVo> rateOfReport(Integer subjectId, Integer year, Long userId);
}
