package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 回款信息对象 base_payment_collection_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BasePaymentCollectionInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 发票id */
    @Excel(name = "发票id")
    private Long invoiceId;

    /** 是否到账 1 已到账 0 未到账 */
    @Excel(name = "是否到账 1 已到账 0 未到账")
    private Long dzFlag;

    /** 回款日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "回款日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date hkTime;

    /** 回款期数 */
    @Excel(name = "回款期数")
    private Long hkqs;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 回款方式 */
    @Excel(name = "回款方式")
    private Integer hkfs;

    /** 开票状态 */
    @Excel(name = "开票状态")
    private Integer kpzt;

    /** 回款凭证 */
    @Excel(name = "回款凭证")
    private String hkpz;

    /** 收款方式 */
    @Excel(name = "收款方式")
    private Long skfs;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 预计到账时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计到账时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date yjdzTime;

    /** 是否删除 1 是 0 否 */
    @Excel(name = "是否删除 1 是 0 否")
    private Long deleteFlag;
}
