package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.uuid.Seq;
import com.ruoyi.system.domain.business.BaseSubjectInfo;
import com.ruoyi.system.mapper.business.BaseContractInfoMapper;
import com.ruoyi.system.mapper.business.BaseSubjectInfoMapper;
import com.ruoyi.system.service.business.IBaseSubjectInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 主体信息Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseSubjectInfoServiceImpl implements IBaseSubjectInfoService
{
    @Autowired
    private BaseSubjectInfoMapper baseSubjectInfoMapper;

    @Autowired
    private BaseContractInfoMapper baseContractInfoMapper;

    /**
     * 查询主体信息
     *
     * @param id 主体信息主键
     * @return 主体信息
     */
    @Override
    public BaseSubjectInfo selectBaseSubjectInfoById(Long id)
    {
        return baseSubjectInfoMapper.selectBaseSubjectInfoById(id);
    }

    /**
     * 查询主体信息列表
     *
     * @param baseSubjectInfo 主体信息
     * @return 主体信息
     */
    @Override
    public List<BaseSubjectInfo> selectBaseSubjectInfoList(BaseSubjectInfo baseSubjectInfo)
    {
        return baseSubjectInfoMapper.selectBaseSubjectInfoList(baseSubjectInfo);
    }

    /**
     * 新增主体信息
     *
     * @param baseSubjectInfo 主体信息
     * @return 结果
     */
    @Override
    public int insertBaseSubjectInfo(BaseSubjectInfo baseSubjectInfo)
    {
        baseSubjectInfo.setCreateTime(DateUtils.getNowDate());
        return baseSubjectInfoMapper.insertBaseSubjectInfo(baseSubjectInfo);
    }

    /**
     * 修改主体信息
     *
     * @param baseSubjectInfo 主体信息
     * @return 结果
     */
    @Override
    public int updateBaseSubjectInfo(BaseSubjectInfo baseSubjectInfo)
    {
        baseSubjectInfo.setUpdateTime(DateUtils.getNowDate());
        return baseSubjectInfoMapper.updateBaseSubjectInfo(baseSubjectInfo);
    }

    /**
     * 批量删除主体信息
     *
     * @param ids 需要删除的主体信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseSubjectInfoByIds(Long[] ids)
    {
        return baseSubjectInfoMapper.deleteBaseSubjectInfoByIds(ids);
    }

    /**
     * 删除主体信息信息
     *
     * @param id 主体信息主键
     * @return 结果
     */
    @Override
    public int deleteBaseSubjectInfoById(Long id)
    {
        return baseSubjectInfoMapper.deleteBaseSubjectInfoById(id);
    }

    @Override
    public String getContractNumber(Long subjectId) {
        BaseSubjectInfo baseSubjectInfo = baseSubjectInfoMapper.selectBaseSubjectInfoById(subjectId);
        // 合同编号前缀
        String orderNoPrefix = Seq.getPrefixFormNo(baseSubjectInfo.getContractPrefix());
        // 查询最大的合同编号
        String contractNoMax = baseContractInfoMapper.selectMaxContractNo(orderNoPrefix);
        return Seq.getFormNo(contractNoMax,baseSubjectInfo.getContractPrefix());
    }
}
