package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseCustomFollowRecord;
import com.ruoyi.system.mapper.business.BaseCustomFollowRecordMapper;
import com.ruoyi.system.service.business.IBaseCustomFollowRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 客户跟踪记录Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseCustomFollowRecordServiceImpl implements IBaseCustomFollowRecordService
{
    @Autowired
    private BaseCustomFollowRecordMapper baseCustomFollowRecordMapper;

    /**
     * 查询客户跟踪记录
     *
     * @param id 客户跟踪记录主键
     * @return 客户跟踪记录
     */
    @Override
    public BaseCustomFollowRecord selectBaseCustomFollowRecordById(Long id)
    {
        return baseCustomFollowRecordMapper.selectBaseCustomFollowRecordById(id);
    }

    /**
     * 查询客户跟踪记录列表
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 客户跟踪记录
     */
    @Override
    public List<BaseCustomFollowRecord> selectBaseCustomFollowRecordList(BaseCustomFollowRecord baseCustomFollowRecord)
    {
        return baseCustomFollowRecordMapper.selectBaseCustomFollowRecordList(baseCustomFollowRecord);
    }

    /**
     * 新增客户跟踪记录
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 结果
     */
    @Override
    public int insertBaseCustomFollowRecord(BaseCustomFollowRecord baseCustomFollowRecord)
    {
        baseCustomFollowRecord.setCreateTime(DateUtils.getNowDate());
        baseCustomFollowRecord.setGjTime(DateUtils.getNowDate());
        return baseCustomFollowRecordMapper.insertBaseCustomFollowRecord(baseCustomFollowRecord);
    }

    /**
     * 修改客户跟踪记录
     *
     * @param baseCustomFollowRecord 客户跟踪记录
     * @return 结果
     */
    @Override
    public int updateBaseCustomFollowRecord(BaseCustomFollowRecord baseCustomFollowRecord)
    {
        baseCustomFollowRecord.setUpdateTime(DateUtils.getNowDate());
        return baseCustomFollowRecordMapper.updateBaseCustomFollowRecord(baseCustomFollowRecord);
    }

    /**
     * 批量删除客户跟踪记录
     *
     * @param ids 需要删除的客户跟踪记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomFollowRecordByIds(Long[] ids)
    {
        return baseCustomFollowRecordMapper.deleteBaseCustomFollowRecordByIds(ids);
    }

    /**
     * 删除客户跟踪记录信息
     *
     * @param id 客户跟踪记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseCustomFollowRecordById(Long id)
    {
        return baseCustomFollowRecordMapper.deleteBaseCustomFollowRecordById(id);
    }
}
