package com.ruoyi.system.service.business;

import com.ruoyi.system.domain.business.BaseSubjectInfo;

import java.util.List;

/**
 * 主体信息Service接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface IBaseSubjectInfoService
{
    /**
     * 查询主体信息
     *
     * @param id 主体信息主键
     * @return 主体信息
     */
    public BaseSubjectInfo selectBaseSubjectInfoById(Long id);

    /**
     * 查询主体信息列表
     *
     * @param baseSubjectInfo 主体信息
     * @return 主体信息集合
     */
    public List<BaseSubjectInfo> selectBaseSubjectInfoList(BaseSubjectInfo baseSubjectInfo);

    /**
     * 新增主体信息
     *
     * @param baseSubjectInfo 主体信息
     * @return 结果
     */
    public int insertBaseSubjectInfo(BaseSubjectInfo baseSubjectInfo);

    /**
     * 修改主体信息
     *
     * @param baseSubjectInfo 主体信息
     * @return 结果
     */
    public int updateBaseSubjectInfo(BaseSubjectInfo baseSubjectInfo);

    /**
     * 批量删除主体信息
     *
     * @param ids 需要删除的主体信息主键集合
     * @return 结果
     */
    public int deleteBaseSubjectInfoByIds(Long[] ids);

    /**
     * 删除主体信息信息
     *
     * @param id 主体信息主键
     * @return 结果
     */
    public int deleteBaseSubjectInfoById(Long id);

    String getContractNumber(Long subjectId);
}
