package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BaseContractInfo;
import com.ruoyi.system.domain.business.vo.ContractCollectVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 合同信息Mapper接口
 *
 * @author gm
 * @date 2025-02-10
 */
public interface BaseContractInfoMapper
{
    /**
     * 查询合同信息
     *
     * @param id 合同信息主键
     * @return 合同信息
     */
    public BaseContractInfo selectBaseContractInfoById(Long id);

    /**
     * 查询合同信息列表
     *
     * @param baseContractInfo 合同信息
     * @return 合同信息集合
     */
    public List<BaseContractInfo> selectBaseContractInfoList(BaseContractInfo baseContractInfo);

    /**
     * 新增合同信息
     *
     * @param baseContractInfo 合同信息
     * @return 结果
     */
    public int insertBaseContractInfo(BaseContractInfo baseContractInfo);

    /**
     * 修改合同信息
     *
     * @param baseContractInfo 合同信息
     * @return 结果
     */
    public int updateBaseContractInfo(BaseContractInfo baseContractInfo);

    /**
     * 删除合同信息
     *
     * @param id 合同信息主键
     * @return 结果
     */
    public int deleteBaseContractInfoById(Long id);

    /**
     * 批量删除合同信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBaseContractInfoByIds(Long[] ids);

    String selectMaxContractNo(String orderNoPrefix);

    ContractCollectVo queryContractAmount();
}
