package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 回款信息对象 base_payment_collection_info
 *
 * @author gm
 * @date 2025-02-10
 */
public class BasePaymentCollectionInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 发票id */
    @Excel(name = "发票id")
    private Long invoiceId;

    /** 是否到账 1 已到账 0 未到账 */
    @Excel(name = "是否到账 1 已到账 0 未到账")
    private Long dzFlag;

    /** 回款日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "回款日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date hkTime;

    /** 回款期数 */
    @Excel(name = "回款期数")
    private Long hkqs;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 回款方式 */
    @Excel(name = "回款方式")
    private Long hkfs;

    /** 回款凭证 */
    @Excel(name = "回款凭证")
    private String hkpz;

    /** 收款方式 */
    @Excel(name = "收款方式")
    private Long skfs;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 预计到账时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计到账时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date yjdzTime;

    /** 是否删除 1 是 0 否 */
    @Excel(name = "是否删除 1 是 0 否")
    private Long deleteFlag;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setContractId(Long contractId)
    {
        this.contractId = contractId;
    }

    public Long getContractId()
    {
        return contractId;
    }
    public void setInvoiceId(Long invoiceId)
    {
        this.invoiceId = invoiceId;
    }

    public Long getInvoiceId()
    {
        return invoiceId;
    }
    public void setDzFlag(Long dzFlag)
    {
        this.dzFlag = dzFlag;
    }

    public Long getDzFlag()
    {
        return dzFlag;
    }
    public void setHkTime(Date hkTime)
    {
        this.hkTime = hkTime;
    }

    public Date getHkTime()
    {
        return hkTime;
    }
    public void setHkqs(Long hkqs)
    {
        this.hkqs = hkqs;
    }

    public Long getHkqs()
    {
        return hkqs;
    }
    public void setHkje(BigDecimal hkje)
    {
        this.hkje = hkje;
    }

    public BigDecimal getHkje()
    {
        return hkje;
    }
    public void setHkfs(Long hkfs)
    {
        this.hkfs = hkfs;
    }

    public Long getHkfs()
    {
        return hkfs;
    }
    public void setHkpz(String hkpz)
    {
        this.hkpz = hkpz;
    }

    public String getHkpz()
    {
        return hkpz;
    }
    public void setSkfs(Long skfs)
    {
        this.skfs = skfs;
    }

    public Long getSkfs()
    {
        return skfs;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }
    public void setYjdzTime(Date yjdzTime)
    {
        this.yjdzTime = yjdzTime;
    }

    public Date getYjdzTime()
    {
        return yjdzTime;
    }
    public void setDeleteFlag(Long deleteFlag)
    {
        this.deleteFlag = deleteFlag;
    }

    public Long getDeleteFlag()
    {
        return deleteFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("contractId", getContractId())
            .append("invoiceId", getInvoiceId())
            .append("dzFlag", getDzFlag())
            .append("hkTime", getHkTime())
            .append("hkqs", getHkqs())
            .append("hkje", getHkje())
            .append("hkfs", getHkfs())
            .append("hkpz", getHkpz())
            .append("skfs", getSkfs())
            .append("bz", getBz())
            .append("yjdzTime", getYjdzTime())
            .append("deleteFlag", getDeleteFlag())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .toString();
    }
}
