package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseInvoiceInfo;
import com.ruoyi.system.service.business.IBaseInvoiceInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 开票信息Controller
 *
 * @author gm
 * @date 2025-02-17
 */
@RestController
@RequestMapping("/invoice/info")
public class BaseInvoiceInfoController extends BaseController
{
    @Autowired
    private IBaseInvoiceInfoService baseInvoiceInfoService;

    /**
     * 查询开票信息列表
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseInvoiceInfo baseInvoiceInfo)
    {
        startPage();
        List<BaseInvoiceInfo> list = baseInvoiceInfoService.selectBaseInvoiceInfoList(baseInvoiceInfo);
        return getDataTable(list);
    }

    /**
     * 导出开票信息列表
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:export')")
    @Log(title = "开票信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseInvoiceInfo baseInvoiceInfo)
    {
        List<BaseInvoiceInfo> list = baseInvoiceInfoService.selectBaseInvoiceInfoList(baseInvoiceInfo);
        ExcelUtil<BaseInvoiceInfo> util = new ExcelUtil<BaseInvoiceInfo>(BaseInvoiceInfo.class);
        util.exportExcel(response, list, "开票信息数据");
    }

    /**
     * 获取开票信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseInvoiceInfoService.selectBaseInvoiceInfoById(id));
    }

    /**
     * 新增开票信息
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:add')")
    @Log(title = "开票信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseInvoiceInfo baseInvoiceInfo)
    {
        return toAjax(baseInvoiceInfoService.insertBaseInvoiceInfo(baseInvoiceInfo));
    }

    /**
     * 修改开票信息
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:edit')")
    @Log(title = "开票信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseInvoiceInfo baseInvoiceInfo)
    {
        return toAjax(baseInvoiceInfoService.updateBaseInvoiceInfo(baseInvoiceInfo));
    }

    /**
     * 删除开票信息
     */
    @PreAuthorize("@ss.hasPermi('invoice:info:remove')")
    @Log(title = "开票信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseInvoiceInfoService.deleteBaseInvoiceInfoByIds(ids));
    }
}
