package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同信息对象 base_contract_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseContractInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 主体id */
    private Long subjectId;

    /** 主体名称 */
    private Long subjectName;

    /** 合同编号 */
    @Excel(name = "合同编号")
    private String htbh;

    /** 部门id */
    @Excel(name = "部门id")
    private Long bmId;

    /** 所属部门 */
    @Excel(name = "所属部门")
    private String ssbm;

    /** 业务员id */
    @Excel(name = "业务员id")
    private Long ywyId;

    /** 业务员 */
    @Excel(name = "业务员")
    private String ywy;

    /** 客户id */
    @Excel(name = "客户id")
    private Long khId;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String khmc;

    /** 合同名称 */
    @Excel(name = "合同名称")
    private String htmc;

    /** 产品类别 */
    @Excel(name = "产品类别")
    private Long cplb;

    /** 甲方公司名称 */
    @Excel(name = "甲方公司名称")
    private String jGsmc;

    /** 甲方通讯地址 */
    @Excel(name = "甲方通讯地址")
    private String jTxdz;

    /** 甲方邮编 */
    @Excel(name = "甲方邮编")
    private String jYb;

    /** 甲方电子邮件 */
    @Excel(name = "甲方电子邮件")
    private String jDzyj;

    /** 甲方汇款人 */
    @Excel(name = "甲方汇款人")
    private String jHkr;

    /** 甲方开户银行 */
    @Excel(name = "甲方开户银行")
    private String jKhyh;

    /** 甲方银行账号 */
    @Excel(name = "甲方银行账号")
    private String jYhzh;

    /** 甲方税务登记号 */
    @Excel(name = "甲方税务登记号")
    private String jSwdjh;

    /** 甲方联系人 */
    @Excel(name = "甲方联系人")
    private String jLxr;

    /** 甲方联系电话 */
    @Excel(name = "甲方联系电话")
    private String jLxdh;

    /** 合同内容 */
    @Excel(name = "合同内容")
    private String htnr;

    /** 签约时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "签约时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date qysj;

    /** 合同状态 */
    @Excel(name = "合同状态")
    private Integer htzt;

    /** 付款方式 */
    @Excel(name = "付款方式")
    private Long fkfs;

    /** 合同生效时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "合同生效时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date htsxsj;

    /** 合同终止时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "合同终止时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date htzzsj;

    /** 期数 */
    @Excel(name = "期数")
    private Long qs;

    /** 合同总额 */
    @Excel(name = "合同总额")
    private BigDecimal htze;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 付款比例 逗号分割 */
    @Excel(name = "付款比例 逗号分割")
    private String fkbl;

    /** 是否返点 1 返 0 不返 */
    @Excel(name = "是否返点 1 返 0 不返")
    private Long fdFlag;

    /** 返点金额 */
    @Excel(name = "返点金额")
    private BigDecimal fdje;

    /** 合同当前节点 */
    @Excel(name = "合同当前节点")
    private Integer dqjd;

    /** 审核状态 */
    @Excel(name = "审核状态")
    private Integer shzt;

    /** 主体地位 */
    @Excel(name = "主体地位")
    private Long ztdw;

    /** 合同附件链接 */
    @Excel(name = "合同附件链接")
    private String htfj;

    /** 审核人id */
    @Excel(name = "审核人id")
    private Long shrId;

    /** 审核人 */
    @Excel(name = "审核人")
    private String shrName;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 是否删除 1 是 0 正常 */
    @Excel(name = "是否删除 1 是 0 正常")
    private Long deleteFlag;

    /** 最小金额 */
    private BigDecimal htMinAmount;

    /** 最大金额 */
    private BigDecimal htMaxAmount;

    /** 期数集合 */
    private List<BaseContractPeriodsInfo> baseContractPeriodsInfos;

    /** 审批记录 */
    private List<BaseContractAuditRecord> baseContractAuditRecords;

    // 生效时间查询类型
    private Integer htsxsjType;

    // 终止时间查询类型
    private Integer htzzsjType;
}
