package com.ruoyi.web.controller.business;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseCustomFollowRecord;
import com.ruoyi.system.service.business.IBaseCustomFollowRecordService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 客户跟踪记录Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/customFollow/record")
public class BaseCustomFollowRecordController extends BaseController
{
    @Autowired
    private IBaseCustomFollowRecordService baseCustomFollowRecordService;

    /**
     * 查询客户跟踪记录列表
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseCustomFollowRecord baseCustomFollowRecord)
    {
        startPage();
        List<BaseCustomFollowRecord> list = baseCustomFollowRecordService.selectBaseCustomFollowRecordList(baseCustomFollowRecord);
        return getDataTable(list);
    }

    /**
     * 导出客户跟踪记录列表
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:export')")
    @Log(title = "客户跟踪记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseCustomFollowRecord baseCustomFollowRecord)
    {
        List<BaseCustomFollowRecord> list = baseCustomFollowRecordService.selectBaseCustomFollowRecordList(baseCustomFollowRecord);
        ExcelUtil<BaseCustomFollowRecord> util = new ExcelUtil<BaseCustomFollowRecord>(BaseCustomFollowRecord.class);
        util.exportExcel(response, list, "客户跟踪记录数据");
    }

    /**
     * 获取客户跟踪记录详细信息
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseCustomFollowRecordService.selectBaseCustomFollowRecordById(id));
    }

    /**
     * 新增客户跟踪记录
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:add')")
    @Log(title = "客户跟踪记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseCustomFollowRecord baseCustomFollowRecord)
    {
        baseCustomFollowRecord.setGjr(getLoginUser().getUser().getNickName());
        return toAjax(baseCustomFollowRecordService.insertBaseCustomFollowRecord(baseCustomFollowRecord));
    }

    /**
     * 修改客户跟踪记录
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:edit')")
    @Log(title = "客户跟踪记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseCustomFollowRecord baseCustomFollowRecord)
    {
        baseCustomFollowRecord.setUpdateTime(new Date());
        baseCustomFollowRecord.setUpdateBy(getLoginUser().getUser().getNickName());
        return toAjax(baseCustomFollowRecordService.updateBaseCustomFollowRecord(baseCustomFollowRecord));
    }

    /**
     * 删除客户跟踪记录
     */
    // @PreAuthorize("@ss.hasPermi('customFollow:record:remove')")
    @Log(title = "客户跟踪记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseCustomFollowRecordService.deleteBaseCustomFollowRecordByIds(ids));
    }
}
