package com.ruoyi.common.utils;

import java.math.BigDecimal;

public class MoneyConverter {
    private static final String[] CN_NUMBERS = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
    private static final String[] CN_UNITS = {"", "拾", "佰", "仟", "万", "拾万", "佰万", "仟万", "亿"};
    private static final String[] DECIMAL_UNITS = {"元", "角", "分"};

    public static String convert(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO)  == 0) {
            return "零元整";
        }

        StringBuilder result = new StringBuilder();
        long integerPart = amount.longValue();
        int decimalPart = amount.remainder(BigDecimal.ONE).movePointRight(2).intValueExact();

        // 转换整数部分
        convertInteger(integerPart, result);
        result.append(DECIMAL_UNITS[0]);

        // 转换小数部分
        if (decimalPart > 0) {
            int jiao = decimalPart / 10;
            int fen = decimalPart % 10;

            if (jiao > 0) {
                result.append(CN_NUMBERS[jiao]).append(DECIMAL_UNITS[1]);
            }
            if (fen > 0) {
                result.append(CN_NUMBERS[fen]).append(DECIMAL_UNITS[2]);
            }
        } else {
            result.append(" 整");
        }

        return result.toString()
                .replaceAll("零拾", "零")
                .replaceAll("零佰", "零")
                .replaceAll("零仟", "零")
                .replaceAll("零+", "零");
    }

    private static void convertInteger(long num, StringBuilder sb) {
        int unitIndex = 0;
        while (num > 0) {
            int current = (int) (num % 10);
            if (current != 0) {
                sb.insert(0,  CN_UNITS[unitIndex]);
                sb.insert(0,  CN_NUMBERS[current]);
            }
            num /= 10;
            unitIndex++;
        }
    }
}
