package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同信息对象 base_contract_info
 *
 * @author gm
 * @date 2025-02-10
 */
public class BaseContractInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 主体id */
    private Long subjectId;

    /** 合同编号 */
    @Excel(name = "合同编号")
    private String htbh;

    /** 部门id */
    @Excel(name = "部门id")
    private Long bmId;

    /** 所属部门 */
    @Excel(name = "所属部门")
    private String ssbm;

    /** 业务员id */
    @Excel(name = "业务员id")
    private Long ywyId;

    /** 业务员 */
    @Excel(name = "业务员")
    private String ywy;

    /** 客户id */
    @Excel(name = "客户id")
    private Long khId;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String khmc;

    /** 合同名称 */
    @Excel(name = "合同名称")
    private String htmc;

    /** 产品类别 */
    @Excel(name = "产品类别")
    private Long cplb;

    /** 甲方公司名称 */
    @Excel(name = "甲方公司名称")
    private String jGsmc;

    /** 甲方通讯地址 */
    @Excel(name = "甲方通讯地址")
    private String jTxdz;

    /** 甲方邮编 */
    @Excel(name = "甲方邮编")
    private String jYb;

    /** 甲方电子邮件 */
    @Excel(name = "甲方电子邮件")
    private String jDzyj;

    /** 甲方汇款人 */
    @Excel(name = "甲方汇款人")
    private String jHkr;

    /** 甲方开户银行 */
    @Excel(name = "甲方开户银行")
    private String jKhyh;

    /** 甲方银行账号 */
    @Excel(name = "甲方银行账号")
    private String jYhzh;

    /** 甲方税务登记号 */
    @Excel(name = "甲方税务登记号")
    private String jSwdjh;

    /** 甲方联系人 */
    @Excel(name = "甲方联系人")
    private String jLxr;

    /** 甲方联系电话 */
    @Excel(name = "甲方联系电话")
    private String jLxdh;

    /** 合同内容 */
    @Excel(name = "合同内容")
    private String htnr;

    /** 签约时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "签约时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date qysj;

    /** 合同状态 */
    @Excel(name = "合同状态")
    private Integer htzt;

    /** 付款方式 */
    @Excel(name = "付款方式")
    private Long fkfs;

    /** 合同生效时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "合同生效时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date htsxsj;

    /** 合同终止时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "合同终止时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date htzzsj;

    /** 期数 */
    @Excel(name = "期数")
    private Long qs;

    /** 合同总额 */
    @Excel(name = "合同总额")
    private BigDecimal htze;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 付款比例 逗号分割 */
    @Excel(name = "付款比例 逗号分割")
    private String fkbl;

    /** 是否返点 1 返 0 不返 */
    @Excel(name = "是否返点 1 返 0 不返")
    private Long fdFlag;

    /** 返点金额 */
    @Excel(name = "返点金额")
    private BigDecimal fdje;

    /** 合同当前节点 */
    @Excel(name = "合同当前节点")
    private Integer dqjd;

    /** 审核状态 */
    @Excel(name = "审核状态")
    private Integer shzt;

    /** 主体地位 */
    @Excel(name = "主体地位")
    private Long ztdw;

    /** 合同附件链接 */
    @Excel(name = "合同附件链接")
    private String htfj;

    /** 审核人id */
    @Excel(name = "审核人id")
    private Long shrId;

    /** 审核人 */
    @Excel(name = "审核人")
    private String shrName;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 是否删除 1 是 0 正常 */
    @Excel(name = "是否删除 1 是 0 正常")
    private Long deleteFlag;

    /** 最小金额 */
    private BigDecimal htMinAmount;

    /** 最大金额 */
    private BigDecimal htMaxAmount;

    /** 期数集合 */
    private List<BaseContractPeriodsInfo> baseContractPeriodsInfos;

    /** 审批记录 */
    private List<BaseContractAuditRecord> baseContractAuditRecords;

    // 生效时间查询类型
    private Integer htsxsjType;

    // 终止时间查询类型
    private Integer htzzsjType;

    public BaseContractInfo() {
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setHtbh(String htbh)
    {
        this.htbh = htbh;
    }

    public String getHtbh()
    {
        return htbh;
    }
    public void setBmId(Long bmId)
    {
        this.bmId = bmId;
    }

    public Long getBmId()
    {
        return bmId;
    }
    public void setSsbm(String ssbm)
    {
        this.ssbm = ssbm;
    }

    public String getSsbm()
    {
        return ssbm;
    }
    public void setYwyId(Long ywyId)
    {
        this.ywyId = ywyId;
    }

    public Long getYwyId()
    {
        return ywyId;
    }
    public void setYwy(String ywy)
    {
        this.ywy = ywy;
    }

    public String getYwy()
    {
        return ywy;
    }
    public void setKhId(Long khId)
    {
        this.khId = khId;
    }

    public Long getKhId()
    {
        return khId;
    }
    public void setKhmc(String khmc)
    {
        this.khmc = khmc;
    }

    public String getKhmc()
    {
        return khmc;
    }
    public void setHtmc(String htmc)
    {
        this.htmc = htmc;
    }

    public String getHtmc()
    {
        return htmc;
    }
    public void setCplb(Long cplb)
    {
        this.cplb = cplb;
    }

    public Long getCplb()
    {
        return cplb;
    }
    public void setjGsmc(String jGsmc)
    {
        this.jGsmc = jGsmc;
    }

    public String getjGsmc()
    {
        return jGsmc;
    }
    public void setjTxdz(String jTxdz)
    {
        this.jTxdz = jTxdz;
    }

    public String getjTxdz()
    {
        return jTxdz;
    }
    public void setjYb(String jYb)
    {
        this.jYb = jYb;
    }

    public String getjYb()
    {
        return jYb;
    }
    public void setjDzyj(String jDzyj)
    {
        this.jDzyj = jDzyj;
    }

    public String getjDzyj()
    {
        return jDzyj;
    }
    public void setjHkr(String jHkr)
    {
        this.jHkr = jHkr;
    }

    public String getjHkr()
    {
        return jHkr;
    }
    public void setjKhyh(String jKhyh)
    {
        this.jKhyh = jKhyh;
    }

    public String getjKhyh()
    {
        return jKhyh;
    }
    public void setjYhzh(String jYhzh)
    {
        this.jYhzh = jYhzh;
    }

    public String getjYhzh()
    {
        return jYhzh;
    }
    public void setjSwdjh(String jSwdjh)
    {
        this.jSwdjh = jSwdjh;
    }

    public String getjSwdjh()
    {
        return jSwdjh;
    }
    public void setjLxr(String jLxr)
    {
        this.jLxr = jLxr;
    }

    public String getjLxr()
    {
        return jLxr;
    }
    public void setjLxdh(String jLxdh)
    {
        this.jLxdh = jLxdh;
    }

    public String getjLxdh()
    {
        return jLxdh;
    }
    public void setHtnr(String htnr)
    {
        this.htnr = htnr;
    }

    public String getHtnr()
    {
        return htnr;
    }
    public void setQysj(Date qysj)
    {
        this.qysj = qysj;
    }

    public Date getQysj()
    {
        return qysj;
    }
    public void setHtzt(Integer htzt)
    {
        this.htzt = htzt;
    }

    public Integer getHtzt()
    {
        return htzt;
    }
    public void setFkfs(Long fkfs)
    {
        this.fkfs = fkfs;
    }

    public Long getFkfs()
    {
        return fkfs;
    }
    public void setHtsxsj(Date htsxsj)
    {
        this.htsxsj = htsxsj;
    }

    public Date getHtsxsj()
    {
        return htsxsj;
    }
    public void setHtzzsj(Date htzzsj)
    {
        this.htzzsj = htzzsj;
    }

    public Date getHtzzsj()
    {
        return htzzsj;
    }
    public void setQs(Long qs)
    {
        this.qs = qs;
    }

    public Long getQs()
    {
        return qs;
    }
    public void setHtze(BigDecimal htze)
    {
        this.htze = htze;
    }

    public BigDecimal getHtze()
    {
        return htze;
    }
    public void setFkbl(String fkbl)
    {
        this.fkbl = fkbl;
    }

    public String getFkbl()
    {
        return fkbl;
    }
    public void setFdFlag(Long fdFlag)
    {
        this.fdFlag = fdFlag;
    }

    public Long getFdFlag()
    {
        return fdFlag;
    }
    public void setFdje(BigDecimal fdje)
    {
        this.fdje = fdje;
    }

    public BigDecimal getFdje()
    {
        return fdje;
    }
    public void setDqjd(Integer dqjd)
    {
        this.dqjd = dqjd;
    }

    public Integer getDqjd()
    {
        return dqjd;
    }
    public void setZtdw(Long ztdw)
    {
        this.ztdw = ztdw;
    }

    public Long getZtdw()
    {
        return ztdw;
    }
    public void setHtfj(String htfj)
    {
        this.htfj = htfj;
    }

    public String getHtfj()
    {
        return htfj;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }
    public void setDeleteFlag(Long deleteFlag)
    {
        this.deleteFlag = deleteFlag;
    }

    public Long getDeleteFlag()
    {
        return deleteFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("htbh", getHtbh())
            .append("bmId", getBmId())
            .append("ssbm", getSsbm())
            .append("ywyId", getYwyId())
            .append("ywy", getYwy())
            .append("khId", getKhId())
            .append("khmc", getKhmc())
            .append("htmc", getHtmc())
            .append("cplb", getCplb())
            .append("jGsmc", getjGsmc())
            .append("jTxdz", getjTxdz())
            .append("jYb", getjYb())
            .append("jDzyj", getjDzyj())
            .append("jHkr", getjHkr())
            .append("jKhyh", getjKhyh())
            .append("jYhzh", getjYhzh())
            .append("jSwdjh", getjSwdjh())
            .append("jLxr", getjLxr())
            .append("jLxdh", getjLxdh())
            .append("htnr", getHtnr())
            .append("qysj", getQysj())
            .append("htzt", getHtzt())
            .append("fkfs", getFkfs())
            .append("htsxsj", getHtsxsj())
            .append("htzzsj", getHtzzsj())
            .append("qs", getQs())
            .append("htze", getHtze())
            .append("fkbl", getFkbl())
            .append("fdFlag", getFdFlag())
            .append("fdje", getFdje())
            .append("dqjd", getDqjd())
            .append("ztdw", getZtdw())
            .append("htfj", getHtfj())
            .append("bz", getBz())
            .append("deleteFlag", getDeleteFlag())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .toString();
    }

    public BigDecimal getHkje() {
        return hkje;
    }

    public void setHkje(BigDecimal hkje) {
        this.hkje = hkje;
    }

    public List<BaseContractPeriodsInfo> getBaseContractPeriodsInfos() {
        return baseContractPeriodsInfos;
    }

    public void setBaseContractPeriodsInfos(List<BaseContractPeriodsInfo> baseContractPeriodsInfos) {
        this.baseContractPeriodsInfos = baseContractPeriodsInfos;
    }

    public List<BaseContractAuditRecord> getBaseContractAuditRecords() {
        return baseContractAuditRecords;
    }

    public void setBaseContractAuditRecords(List<BaseContractAuditRecord> baseContractAuditRecords) {
        this.baseContractAuditRecords = baseContractAuditRecords;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public Long getShrId() {
        return shrId;
    }

    public void setShrId(Long shrId) {
        this.shrId = shrId;
    }


    public String getShrName() {
        return shrName;
    }

    public void setShrName(String shrName) {
        this.shrName = shrName;
    }

    public Integer getShzt() {
        return shzt;
    }

    public void setShzt(Integer shzt) {
        this.shzt = shzt;
    }

    public BigDecimal getHtMinAmount() {
        return htMinAmount;
    }

    public void setHtMinAmount(BigDecimal htMinAmount) {
        this.htMinAmount = htMinAmount;
    }

    public BigDecimal getHtMaxAmount() {
        return htMaxAmount;
    }

    public void setHtMaxAmount(BigDecimal htMaxAmount) {
        this.htMaxAmount = htMaxAmount;
    }

    public Integer getHtsxsjType() {
        return htsxsjType;
    }

    public void setHtsxsjType(Integer htsxsjType) {
        this.htsxsjType = htsxsjType;
    }

    public Integer getHtzzsjType() {
        return htzzsjType;
    }

    public void setHtzzsjType(Integer htzzsjType) {
        this.htzzsjType = htzzsjType;
    }
}
