package com.ruoyi.web.controller.business;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.system.domain.business.BaseSubjectInfo;
import com.ruoyi.system.service.business.IBaseSubjectInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 主体信息Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/subject/info")
public class BaseSubjectInfoController extends BaseController
{
    @Autowired
    private IBaseSubjectInfoService baseSubjectInfoService;

    /**
     * 查询主体信息列表
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseSubjectInfo baseSubjectInfo)
    {
        startPage();
        List<BaseSubjectInfo> list = baseSubjectInfoService.selectBaseSubjectInfoList(baseSubjectInfo);
        return getDataTable(list);
    }

    /**
     * 导出主体信息列表
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:export')")
    @Log(title = "主体信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseSubjectInfo baseSubjectInfo)
    {
        List<BaseSubjectInfo> list = baseSubjectInfoService.selectBaseSubjectInfoList(baseSubjectInfo);
        ExcelUtil<BaseSubjectInfo> util = new ExcelUtil<BaseSubjectInfo>(BaseSubjectInfo.class);
        util.exportExcel(response, list, "主体信息数据");
    }

    /**
     * 获取主体信息详细信息
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(baseSubjectInfoService.selectBaseSubjectInfoById(id));
    }

    /**
     * 新增主体信息
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:add')")
    @Log(title = "主体信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseSubjectInfo baseSubjectInfo)
    {
        return toAjax(baseSubjectInfoService.insertBaseSubjectInfo(baseSubjectInfo));
    }

    /**
     * 修改主体信息
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:edit')")
    @Log(title = "主体信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseSubjectInfo baseSubjectInfo)
    {
        return toAjax(baseSubjectInfoService.updateBaseSubjectInfo(baseSubjectInfo));
    }

    /**
     * 删除主体信息
     */
    // @PreAuthorize("@ss.hasPermi('subject:info:remove')")
    @Log(title = "主体信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(baseSubjectInfoService.deleteBaseSubjectInfoByIds(ids));
    }

    @GetMapping("/getContractNumber")
    public AjaxResult getContractNumber(Long subjectId)
    {
        String contractNumber = baseSubjectInfoService.getContractNumber(subjectId);
        return success(contractNumber);
    }
}
