package com.ruoyi.system.mapper.business;

import com.ruoyi.system.domain.business.BaseInvoiceAuditRecord;

import java.util.List;

/**
 * 发票审批记录Mapper接口
 *
 * @author gm
 * @date 2025-02-25
 */
public interface BaseInvoiceAuditRecordMapper
{
    /**
     * 查询发票审批记录
     *
     * @param id 发票审批记录主键
     * @return 发票审批记录
     */
    public BaseInvoiceAuditRecord selectBaseInvoiceAuditRecordById(Long id);

    /**
     * 查询发票审批记录列表
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 发票审批记录集合
     */
    public List<BaseInvoiceAuditRecord> selectBaseInvoiceAuditRecordList(BaseInvoiceAuditRecord baseInvoiceAuditRecord);

    /**
     * 新增发票审批记录
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 结果
     */
    public int insertBaseInvoiceAuditRecord(BaseInvoiceAuditRecord baseInvoiceAuditRecord);

    /**
     * 修改发票审批记录
     *
     * @param baseInvoiceAuditRecord 发票审批记录
     * @return 结果
     */
    public int updateBaseInvoiceAuditRecord(BaseInvoiceAuditRecord baseInvoiceAuditRecord);

    /**
     * 删除发票审批记录
     *
     * @param id 发票审批记录主键
     * @return 结果
     */
    public int deleteBaseInvoiceAuditRecordById(Long id);

    /**
     * 批量删除发票审批记录
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBaseInvoiceAuditRecordByIds(Long[] ids);
}
