package com.ruoyi.system.service.business.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.business.BaseContractAuditRecord;
import com.ruoyi.system.mapper.business.BaseContractAuditRecordMapper;
import com.ruoyi.system.service.business.IBaseContractAuditRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 合同审核记录Service业务层处理
 *
 * @author gm
 * @date 2025-02-10
 */
@Service
public class BaseContractAuditRecordServiceImpl implements IBaseContractAuditRecordService
{
    @Autowired
    private BaseContractAuditRecordMapper baseContractAuditRecordMapper;

    /**
     * 查询合同审核记录
     *
     * @param id 合同审核记录主键
     * @return 合同审核记录
     */
    @Override
    public BaseContractAuditRecord selectBaseContractAuditRecordById(Long id)
    {
        return baseContractAuditRecordMapper.selectBaseContractAuditRecordById(id);
    }

    /**
     * 查询合同审核记录列表
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 合同审核记录
     */
    @Override
    public List<BaseContractAuditRecord> selectBaseContractAuditRecordList(BaseContractAuditRecord baseContractAuditRecord)
    {
        return baseContractAuditRecordMapper.selectBaseContractAuditRecordList(baseContractAuditRecord);
    }

    /**
     * 新增合同审核记录
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 结果
     */
    @Override
    public int insertBaseContractAuditRecord(BaseContractAuditRecord baseContractAuditRecord)
    {
        baseContractAuditRecord.setCreateTime(DateUtils.getNowDate());
        return baseContractAuditRecordMapper.insertBaseContractAuditRecord(baseContractAuditRecord);
    }

    /**
     * 修改合同审核记录
     *
     * @param baseContractAuditRecord 合同审核记录
     * @return 结果
     */
    @Override
    public int updateBaseContractAuditRecord(BaseContractAuditRecord baseContractAuditRecord)
    {
        return baseContractAuditRecordMapper.updateBaseContractAuditRecord(baseContractAuditRecord);
    }

    /**
     * 批量删除合同审核记录
     *
     * @param ids 需要删除的合同审核记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractAuditRecordByIds(Long[] ids)
    {
        return baseContractAuditRecordMapper.deleteBaseContractAuditRecordByIds(ids);
    }

    /**
     * 删除合同审核记录信息
     *
     * @param id 合同审核记录主键
     * @return 结果
     */
    @Override
    public int deleteBaseContractAuditRecordById(Long id)
    {
        return baseContractAuditRecordMapper.deleteBaseContractAuditRecordById(id);
    }
}
