package com.ruoyi.system.service.business;

import com.ruoyi.system.domain.business.BasePerformanceCompleteInfo;
import com.ruoyi.system.domain.business.vo.PerformanceCompleteVo;

import java.util.List;

/**
 * 业绩目标Service接口
 *
 * @author gm
 * @date 2025-06-06
 */
public interface IBasePerformanceCompleteInfoService
{
    /**
     * 查询业绩目标
     *
     * @param id 业绩目标主键
     * @return 业绩目标
     */
    public BasePerformanceCompleteInfo selectBasePerformanceCompleteInfoById(Long id);

    /**
     * 查询业绩目标列表
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 业绩目标集合
     */
    public List<PerformanceCompleteVo> selectBasePerformanceCompleteInfoList(BasePerformanceCompleteInfo basePerformanceCompleteInfo);

    /**
     * 新增业绩目标
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 结果
     */
    public int insertBasePerformanceCompleteInfo(BasePerformanceCompleteInfo basePerformanceCompleteInfo);

    /**
     * 修改业绩目标
     *
     * @param basePerformanceCompleteInfo 业绩目标
     * @return 结果
     */
    public void updateBasePerformanceCompleteInfo(PerformanceCompleteVo performanceCompleteVo);

    /**
     * 批量删除业绩目标
     *
     * @param ids 需要删除的业绩目标主键集合
     * @return 结果
     */
    public int deleteBasePerformanceCompleteInfoByIds(Long[] ids);

    /**
     * 删除业绩目标信息
     *
     * @param id 业绩目标主键
     * @return 结果
     */
    public int deleteBasePerformanceCompleteInfoById(Long id);

    List<BasePerformanceCompleteInfo> selectBasePerformanceCompleteInfos(BasePerformanceCompleteInfo basePerformanceCompleteInfo);
}
